/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ChangeModelEquipmentVisibilityMessage(UUID uuid, class_1304 equipmentSlot, boolean visible) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "change_model_equipment_visibility");

    public static ChangeModelEquipmentVisibilityMessage create(class_2540 buffer) {
        return new ChangeModelEquipmentVisibilityMessage(buffer.method_10790(), (class_1304)buffer.method_10818(class_1304.class), buffer.readBoolean());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.equipmentSlot);
        buffer.writeBoolean(this.visible);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.equipmentSlot == null) {
            log.error("Invalid equipmentSlot for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} visibility to {} for {} from {}", (Object)this.equipmentSlot, (Object)this.visible, (Object)easyNPC, (Object)serverPlayer);
        modelData.setModelPartVisibility(this.equipmentSlot, this.visible);
    }
}

