/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record RemoveDialogButtonMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "remove_dialog_button");

    public static RemoveDialogButtonMessage create(class_2540 buffer) {
        return new RemoveDialogButtonMessage(buffer.method_10790(), buffer.method_10790(), buffer.method_10790());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
        buffer.method_10797(this.dialogButtonId);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Invalid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId) || !dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Unknown delete dialog request for dialog button {} for dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (dialogData.removeDialogButton(this.dialogId, this.dialogButtonId)) {
            log.info("Removed dialog button {} from dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
        } else {
            log.warn("Unable to remove dialog button {} from dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

