/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ActionEventDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record ChangeActionEventMessage(UUID uuid, ActionEventType actionEventType, ActionDataSet actionDataSet) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "change_action_event");

    public static ChangeActionEventMessage create(class_2540 buffer) {
        return new ChangeActionEventMessage(buffer.method_10790(), (ActionEventType)buffer.method_10818(ActionEventType.class), new ActionDataSet(buffer.method_10798()));
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.actionEventType);
        buffer.method_10794(this.actionDataSet.createTag());
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.actionEventType == null || this.actionEventType == ActionEventType.NONE || this.actionDataSet == null) {
            log.error("Failed to change action event for {}: Invalid data", (Object)easyNPC);
            return;
        }
        int permissionLevel = 0;
        MinecraftServer minecraftServer = serverPlayer.method_5682();
        ActionEventDataCapable actionEventData = easyNPC.getEasyNPCActionEventData();
        if (minecraftServer != null) {
            permissionLevel = minecraftServer.method_3835(serverPlayer.method_7334());
            log.debug("Set action owner permission level {} for {} from {}", (Object)permissionLevel, (Object)easyNPC, (Object)serverPlayer);
            actionEventData.setActionPermissionLevel(permissionLevel);
        } else {
            log.warn("Unable to verify permission level from {} for {}", (Object)this, (Object)serverPlayer);
        }
        log.debug("Set action event {} with {} for {} from {} with owner permission level {}.", (Object)this.actionEventType, (Object)this.actionDataSet, (Object)easyNPC, (Object)serverPlayer, (Object)permissionLevel);
        actionEventData.getActionEventSet().setActionEvent(this.actionEventType, this.actionDataSet);
    }
}

