/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4050;

public record ChangeModelScaleMessage(UUID uuid, ModelPartType modelPartType, CustomScale scale) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "change_model_scale");

    public static ChangeModelScaleMessage create(class_2540 buffer) {
        return new ChangeModelScaleMessage(buffer.method_10790(), (ModelPartType)buffer.method_10818(ModelPartType.class), new CustomScale(buffer.readFloat(), buffer.readFloat(), buffer.readFloat()));
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.modelPartType);
        buffer.writeFloat(this.scale.x());
        buffer.writeFloat(this.scale.y());
        buffer.writeFloat(this.scale.z());
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPartType == null) {
            log.error("Invalid modelPartType for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.scale == null) {
            log.error("Invalid scale for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change {} scale to {}\u00b0 for {} from {}", (Object)this.modelPartType, (Object)this.scale, (Object)easyNPC, (Object)serverPlayer);
        if (this.modelPartType != ModelPartType.ROOT) {
            easyNPC.getEntity().method_18380(class_4050.field_18076);
            modelData.setModelPose(ModelPose.CUSTOM);
        }
        modelData.setModelPartScale(this.modelPartType, this.scale);
        if (!modelData.hasChangedModel()) {
            log.debug("Reset custom model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            modelData.setModelPose(ModelPose.DEFAULT);
        }
    }
}

