/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action;

import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.UpDownButton;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ActionDataListEntry
extends ObjectSelectionList.Entry<ActionDataListEntry> {
    public static final int ID_LEFT_POS = 0;
    public static final int TYPE_LEFT_POS = 22;
    public static final int VALUE_LEFT_POS = 130;
    public static final int OPTIONS_LEFT_POS = 230;
    private final Font font;
    private final int leftPos;
    private final int topPos;
    private final int entryHeight = 21;
    private final ActionDataEntry actionDataEntry;
    private final ActionDataType actionDataType;
    private final int actionDateEntriesSize;
    private final EditButton editButton;
    private final DeleteButton deleteButton;
    private final UpDownButton upAndDownButton;

    public ActionDataListEntry(Minecraft minecraft, ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, int leftPos, int topPos, OnUp onUp, OnDown onDown, OnEdit onEdit, OnRemove onRemove) {
        this.font = minecraft.font;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.actionDataEntry = actionDataEntry;
        this.actionDataType = actionDataEntry != null ? actionDataEntry.actionDataType() : ActionDataType.NONE;
        this.actionDateEntriesSize = actionDataSet != null ? actionDataSet.getEntries().size() : 1;
        this.upAndDownButton = new UpDownButton(this.leftPos + 230 + 4, this.topPos, 18, 18, onPress -> {
            if (onUp != null) {
                onUp.changeOrder(actionDataEntry);
            }
        }, onPress -> {
            if (onDown != null) {
                onDown.changeOrder(actionDataEntry);
            }
        });
        this.editButton = new EditButton(this.upAndDownButton.getX() + this.upAndDownButton.getWidth() + 2, this.topPos, 18, 18, onPress -> {
            if (onEdit != null) {
                onEdit.edit(actionDataEntry);
            }
        });
        this.deleteButton = new DeleteButton(this.editButton.getX() + this.editButton.getWidth() + 2, this.topPos, onPress -> {
            if (onRemove != null) {
                onRemove.remove(actionDataEntry);
            }
        });
    }

    public Component getNarration() {
        return TextComponent.getText((String)(this.actionDataType.name() + ":" + this.actionDataEntry.command()));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.upAndDownButton.mouseClicked(mouseX, mouseY, button);
        this.editButton.mouseClicked(mouseX, mouseY, button);
        this.deleteButton.mouseClicked(mouseX, mouseY, button);
        return button == 0;
    }

    public void render(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        guiGraphics.fill(this.leftPos, top + entryHeight + 2, this.leftPos + 309, top + entryHeight + 3, -5592406);
        int fieldsLeft = this.leftPos + 5;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)String.valueOf(entryId), (int)(fieldsLeft + 0 + 2), (int)(top + 5), (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)this.actionDataType.getId(), (int)(fieldsLeft + 22 + 2), (int)(top + 5), (int)0);
        if (this.actionDataType == ActionDataType.COMMAND || this.actionDataType == ActionDataType.OPEN_NAMED_DIALOG) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.limitString((String)this.actionDataEntry.command(), (int)16), (int)(fieldsLeft + 130 + 2), (int)(top + 5), (int)0);
        } else if (this.actionDataType == ActionDataType.INTERACT_BLOCK) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.limitString((String)this.actionDataEntry.blockPos().toString(), (int)16), (int)(fieldsLeft + 130 + 2), (int)(top + 5), (int)0);
        }
        this.upAndDownButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.upAndDownButton.setY(top);
        this.upAndDownButton.enableUpButton(entryId > 0);
        this.upAndDownButton.enableDownButton(entryId < this.actionDateEntriesSize - 1);
        this.editButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.editButton.setY(top);
        this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.deleteButton.setY(top);
        this.renderSeparatorLines(guiGraphics, top);
    }

    public void renderSeparatorLines(GuiGraphics guiGraphics, int top) {
        int separatorTop = top - 1;
        int separatorLeft = this.leftPos + 5;
        guiGraphics.fill(separatorLeft + 22 - 3, separatorTop, separatorLeft + 22 - 2, separatorTop + 21, -10066330);
        guiGraphics.fill(separatorLeft + 130 - 3, separatorTop, separatorLeft + 130 - 2, separatorTop + 21, -10066330);
        guiGraphics.fill(separatorLeft + 230 - 3, separatorTop, separatorLeft + 230 - 2, separatorTop + 21, -10066330);
    }

    public static interface OnUp {
        public void changeOrder(ActionDataEntry var1);
    }

    public static interface OnDown {
        public void changeOrder(ActionDataEntry var1);
    }

    public static interface OnEdit {
        public void edit(ActionDataEntry var1);
    }

    public static interface OnRemove {
        public void remove(ActionDataEntry var1);
    }
}

