/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.configuration.trading;

import de.markusbordihn.easynpc.configui.handler.TradingContainerHandler;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.TradingConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.slot.ItemASlot;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.slot.ItemBSlot;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.slot.ItemResultSlot;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class BasicTradingConfigurationMenu
extends TradingConfigurationMenu {
    public static final int SLOT_SIZE = 18;
    public static final int TRADING_SLOT_SIZE = 18;
    public static final int TRADING_START_POSITION_X = 30;
    public static final int TRADING_START_POSITION_Y = 40;
    public static final int TRADING_START_POSITION_SECOND_ROW_X = 190;
    protected static final int TRADING_CONTAINER_SIZE = 36;
    protected final Container tradingContainer;

    public BasicTradingConfigurationMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, new CompoundTag());
    }

    public BasicTradingConfigurationMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, CompoundTag data) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(36), data);
    }

    public BasicTradingConfigurationMenu(MenuType<?> menuType, int windowId, Inventory playerInventory, Container tradingContainer, CompoundTag data) {
        super(menuType, windowId, playerInventory, data);
        MerchantOffers merchantOffers;
        BasicTradingConfigurationMenu.checkContainerSize((Container)tradingContainer, (int)36);
        this.tradingContainer = tradingContainer;
        if (!this.level.isClientSide && (merchantOffers = this.getEasyNPC().getEasyNPCTradingData().getTradingOffers()) != null) {
            for (int tradingOffer = 0; tradingOffer < 12 && tradingOffer < merchantOffers.size(); ++tradingOffer) {
                MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOffer);
                this.tradingContainer.setItem(tradingOffer * 3, merchantOffer.getBaseCostA());
                this.tradingContainer.setItem(tradingOffer * 3 + 1, merchantOffer.getCostB());
                this.tradingContainer.setItem(tradingOffer * 3 + 2, merchantOffer.getResult());
            }
        }
        int slotPositionX = 30;
        int slotPositionY = 40;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = 190;
                slotPositionY = 40;
            }
            this.addSlot(new ItemASlot(this, tradingContainer, tradingOffer * 3, slotPositionX, slotPositionY));
            this.addSlot(new ItemBSlot(this, tradingContainer, tradingOffer * 3 + 1, slotPositionX + 18 + 18, slotPositionY));
            this.addSlot(new ItemResultSlot(this, tradingContainer, tradingOffer * 3 + 2, slotPositionX + 82, slotPositionY));
            slotPositionY += 19;
        }
        int playerInventoryStartPositionY = 159;
        int playerInventoryStartPositionX = 8;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.addSlot(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, playerInventoryStartPositionX + inventoryColumn * 18, playerInventoryStartPositionY + inventoryRow * 18));
            }
        }
        int hotbarStartPositionY = 215;
        int hotbarStartPositionX = 8;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.addSlot(new Slot((Container)playerInventory, playerInventorySlot, hotbarStartPositionX + playerInventorySlot * 18, hotbarStartPositionY));
        }
    }

    @Override
    public void setTradingChanged() {
        if (this.level.isClientSide) {
            return;
        }
        TradingContainerHandler.setBasicTradingOffers(this.getEasyNPC().getEasyNPCTradingData(), this.tradingContainer);
    }
}

