/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.client;

import de.markusbordihn.easynpc.data.dialog.DialogDataManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record SyncDataMessage(UUID uuid, DialogDataSet dialogDataSet) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"sync_data");
    public static final CustomPacketPayload.Type<SyncDataMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncDataMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), SyncDataMessage::create);

    public static SyncDataMessage create(FriendlyByteBuf buffer) {
        return new SyncDataMessage(buffer.readUUID(), new DialogDataSet(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeNbt((Tag)this.dialogDataSet.createTag());
    }

    public CustomPacketPayload.Type<SyncDataMessage> type() {
        return PAYLOAD_TYPE;
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleClient() {
        if (this.uuid == null || this.uuid.toString().isEmpty()) {
            log.error("Invalid UUID {} for {}", (Object)this.uuid, (Object)this);
            return;
        }
        if (this.dialogDataSet != null) {
            log.debug("Syncing dialog data for {} with {}", (Object)this.uuid, (Object)this.dialogDataSet);
            DialogDataManager.addDialogDataSet((UUID)this.uuid, (DialogDataSet)this.dialogDataSet);
        }
    }
}

