/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.ContainerScreen;
import de.markusbordihn.easynpc.configui.menu.ConfigUIMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ConfigurationContainerScreen<T extends ConfigUIMenu>
extends ContainerScreen<T> {
    protected Button homeButton = null;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;

    public ConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = false;
    }

    @Override
    public void init() {
        super.init();
        this.buttonLeftPos = this.leftPos + 13;
        this.buttonTopPos = this.topPos + 3;
        this.contentLeftPos = this.leftPos + 7;
        this.contentTopPos = this.topPos + 23;
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 3, this.buttonTopPos, 10, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN)));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        if (!this.compactMode) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (Component)this.title, (int)this.titleLabelX, (int)this.titleLabelY, (int)0x404040);
        }
    }

    public void showMainScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
    }

    @Override
    public boolean keyPressed(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 && ConfigurationContainerScreen.hasAltDown()) {
            this.showMainScreen();
            return true;
        }
        return super.keyPressed(keyCode, unused1, unused2);
    }
}

