/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration;

import de.markusbordihn.easynpc.client.screen.Screen;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.ScreenInterface;
import de.markusbordihn.easynpc.configui.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.configui.menu.ConfigUIMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ConfigurationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class ConfigurationScreen<T extends ConfigUIMenu>
extends Screen<T, AdditionalScreenData>
implements ScreenInterface {
    protected Button homeButton = null;
    protected int buttonLeftPos;
    protected int buttonTopPos;
    protected int contentLeftPos;
    protected int contentTopPos;
    protected int numberOfDescriptionTextLines = 1;
    protected List<FormattedCharSequence> descriptionTextComponents = Collections.emptyList();

    public ConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component, 328, 243);
        this.showCloseButton = false;
    }

    protected void renderDescriptionText(GuiGraphics guiGraphics, int descriptionLeft, int descriptionTop) {
        if (!this.descriptionTextComponents.isEmpty() && this.numberOfDescriptionTextLines > 0) {
            for (int line = 0; line < this.numberOfDescriptionTextLines; ++line) {
                FormattedCharSequence formattedCharSequence = this.descriptionTextComponents.get(line);
                Objects.requireNonNull(this.font);
                Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (FormattedCharSequence)formattedCharSequence, (int)descriptionLeft, (int)(descriptionTop + line * (9 + 2)));
            }
        }
    }

    protected void setDescriptionText(String textId) {
        this.setDescriptionText((Component)TextComponent.getTranslatedConfigText((String)textId));
    }

    protected void setDescriptionText(Component component) {
        this.descriptionTextComponents = this.font.split((FormattedText)component, this.imageWidth - 20);
        this.numberOfDescriptionTextLines = this.descriptionTextComponents.size();
    }

    public void init() {
        super.init();
        this.buttonLeftPos = this.leftPos + 13;
        this.buttonTopPos = this.topPos + 3;
        this.contentLeftPos = this.leftPos + 7;
        this.contentTopPos = this.topPos + 23;
        this.homeButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.leftPos + 3, this.buttonTopPos, 10, "<", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN)));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        if (!this.compactMode) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (Component)this.title, (int)(this.leftPos + this.titleLabelX), (int)(this.topPos + this.titleLabelY), (int)0x404040);
        }
    }

    public void showMainScreen() {
        NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.MAIN);
    }

    public boolean keyPressed(int keyCode, int unused1, int unused2) {
        if (keyCode == 263 && ConfigurationScreen.hasAltDown()) {
            this.showMainScreen();
            return true;
        }
        return super.keyPressed(keyCode, unused1, unused2);
    }

    protected boolean supportsConfigurationType(ConfigurationType configurationType) {
        EasyNPC easyNPC = this.getEasyNPC();
        if (easyNPC == null) {
            return false;
        }
        ConfigurationDataCapable configurationData = easyNPC.getEasyNPCConfigurationData();
        if (configurationData == null) {
            return true;
        }
        if (!configurationData.supportsConfigurationType(configurationType)) {
            return false;
        }
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        boolean isCustomModel = renderData != null && renderData.getRenderDataSet() != null && renderData.getRenderDataSet().getRenderType() != RenderType.DEFAULT;
        return !isCustomModel || configurationType != ConfigurationType.POSE && configurationType != ConfigurationType.SCALING && configurationType != ConfigurationType.SKIN;
    }
}

