/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.AddButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextEditButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen;
import de.markusbordihn.easynpc.configui.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class AdvancedDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    private static final int COLUMN_PRIORITY_WIDTH = 25;
    private static final int COLUMN_LABEL_WIDTH = 95;
    private static final int COLUMN_NAME_WIDTH = 96;
    private static final int COLUMN_TEXT_WIDTH = 96;
    private static final int COLUMN_PRIORITY_START = 4;
    private static final int COLUMN_LABEL_START = 33;
    private static final int COLUMN_NAME_START = 128;
    private static final int COLUMN_TEXT_START = 224;
    private static final int LIST_AREA_TOP_OFFSET = 20;
    private static final int LIST_AREA_BOTTOM = 190;
    private static final int HEADER_HEIGHT = 18;
    private static final int FOOTER_HEIGHT = 20;
    private static final float TEXT_SCALE = 0.75f;
    Button newDialogButton;
    DialogList dialogList;

    public AdvancedDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.advancedDialogButton.active = false;
        this.newDialogButton = (Button)this.addRenderableWidget((GuiEventListener)new AddButton(this.contentLeftPos + 4, this.contentTopPos + 193, 300, "dialog.add", onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(this.getEasyNPCUUID())));
        this.dialogList = new DialogList();
        this.addWidget((GuiEventListener)this.dialogList);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        int listLeft = this.leftPos + 4;
        int listRight = this.leftPos + 224 + 96 + 4;
        int listTop = this.contentTopPos + 20;
        int listBottom = this.contentTopPos + 190 + 20;
        guiGraphics.fill(listLeft, listTop, listRight, listBottom, -1118482);
        guiGraphics.fill(this.leftPos + 33 - 1, listTop, this.leftPos + 33, this.contentTopPos + 190, -4473925);
        guiGraphics.fill(this.leftPos + 128, listTop, this.leftPos + 128 + 1, this.contentTopPos + 190, -4473925);
        guiGraphics.fill(this.leftPos + 224 - 1, listTop, this.leftPos + 224, this.contentTopPos + 190, -4473925);
        if (this.dialogList != null) {
            this.dialogList.renderSelectionList(guiGraphics, x, y, partialTicks);
        }
        guiGraphics.fill(listLeft, this.contentTopPos, listRight, this.contentTopPos + 18, -5592406);
        guiGraphics.fill(listLeft, this.contentTopPos + 190 + 1, listRight, listBottom, -3750202);
        int headerLeft = this.leftPos + 4 + 5;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Prio", (int)headerLeft, (int)(this.contentTopPos + 5), (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"label_id", (int)(this.leftPos + 33 + 3), (int)(this.contentTopPos + 5), (int)0);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Name", (int)(this.leftPos + 128 + 3), (int)(this.contentTopPos + 5), (int)0);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Text", (int)(this.leftPos + 224 + 2), (int)(this.contentTopPos + 5), (int)0);
        guiGraphics.fill(this.leftPos + 33 - 1, this.contentTopPos, this.leftPos + 33, this.contentTopPos + 18, -10066330);
        guiGraphics.fill(this.leftPos + 128, this.contentTopPos, this.leftPos + 128 + 1, this.contentTopPos + 18, -10066330);
        guiGraphics.fill(this.leftPos + 224 - 1, this.contentTopPos, this.leftPos + 224, this.contentTopPos + 18, -10066330);
        if (this.newDialogButton != null) {
            this.newDialogButton.render(guiGraphics, x, y, partialTicks);
        }
    }

    class DialogList
    extends ObjectSelectionList<de.markusbordihn.easynpc.configui.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
        DialogList() {
            super(AdvancedDialogConfigurationScreen.this.minecraft, AdvancedDialogConfigurationScreen.this.width + 60, 177, AdvancedDialogConfigurationScreen.this.contentTopPos + 15, 19);
            this.setRenderHeader(false, 0);
            AdvancedDialogConfigurationScreen.this.getDialogDataSet().getDialogsByLabel().stream().filter(dialogData -> dialogData != null && dialogData.getId() != null).sorted(Comparator.comparingInt(DialogDataEntry::getPriority).reversed().thenComparing(Comparator.comparing(DialogDataEntry::getLabel))).forEach(dialogData -> this.addEntry((AbstractSelectionList.Entry)new Entry((DialogDataEntry)dialogData)));
        }

        public void renderSelectionList(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            if (this.getItemCount() > 0) {
                super.render(guiGraphics, x, y, partialTicks);
            }
        }

        protected void renderSelection(GuiGraphics guiGraphics, int unused1, int unused2, int unused3, int unused4, int unused5) {
        }

        protected void renderListSeparators(GuiGraphics guiGraphics) {
        }

        protected void renderListBackground(GuiGraphics guiGraphics) {
        }

        class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.configui.client.screen.configuration.dialog.AdvancedDialogConfigurationScreen$DialogList.Entry> {
            final DialogDataEntry dialogData;
            final EditButton editButton;
            final CopyButton copyLabelButton;
            final TextEditButton textEditButton;

            public Entry(DialogDataEntry dialogData) {
                this.dialogData = dialogData;
                this.editButton = new EditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
                this.copyLabelButton = new CopyButton(0, 0, onPress -> {
                    Minecraft minecraft = Minecraft.getInstance();
                    minecraft.keyboardHandler.setClipboard(dialogData.getLabel());
                });
                this.textEditButton = new TextEditButton(0, 0, onPress -> NetworkMessageHandlerManager.getServerHandler().openDialogTextEditor(AdvancedDialogConfigurationScreen.this.getEasyNPCUUID(), this.dialogData.getId()));
            }

            public Component getNarration() {
                return TextComponent.getTextComponent((String)this.dialogData.getName());
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                super.mouseClicked(mouseX, mouseY, button);
                this.copyLabelButton.mouseClicked(mouseX, mouseY, button);
                this.editButton.mouseClicked(mouseX, mouseY, button);
                this.textEditButton.mouseClicked(mouseX, mouseY, button);
                return button == 0;
            }

            public void render(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
                int leftPos = left - 80;
                int buttonWidth = 16;
                this.editButton.setX(leftPos + 128 - buttonWidth - 7);
                this.editButton.setY(top);
                this.editButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.editButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText((String)"dialog.edit_dialog", (String)this.dialogData.getName()), mouseX, mouseY);
                }
                this.copyLabelButton.setX(this.editButton.getX() - this.editButton.getWidth());
                this.copyLabelButton.setY(top);
                this.copyLabelButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.copyLabelButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText((String)"dialog.copy_dialog_label", (String)this.dialogData.getLabel()), mouseX, mouseY);
                }
                this.textEditButton.setX(leftPos + 224 - 5);
                this.textEditButton.setY(top);
                this.textEditButton.render(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.textEditButton.isHovered()) {
                    guiGraphics.renderTooltip(AdvancedDialogConfigurationScreen.this.font, (Component)TextComponent.getTranslatedConfigText((String)"dialog.edit_dialog_text", (String)this.dialogData.getText()), mouseX, mouseY);
                }
                int dialogDataTopPos = Math.round((float)(top + 5) / 0.75f);
                int fontColor = switch (this.dialogData.getPriority()) {
                    case 100 -> 0xFF5555;
                    case 10 -> 43520;
                    case 5 -> 0;
                    case 1 -> 0xAAAAAA;
                    case 0 -> 0xA0A0A0;
                    case -1 -> 0xAAAAAA;
                    default -> 0;
                };
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.75f, 0.75f, 0.75f);
                Text.drawString((GuiGraphics)guiGraphics, (Font)AdvancedDialogConfigurationScreen.this.font, (String)String.valueOf(this.dialogData.getPriority()), (int)Math.round((float)(leftPos + 4 - 1) / 0.75f), (int)dialogDataTopPos, (int)fontColor);
                Text.drawString((GuiGraphics)guiGraphics, (Font)AdvancedDialogConfigurationScreen.this.font, (String)this.dialogData.getLabel(14), (int)Math.round((float)(leftPos + 33 - 4) / 0.75f), (int)dialogDataTopPos, (int)fontColor);
                Text.drawString((GuiGraphics)guiGraphics, (Font)AdvancedDialogConfigurationScreen.this.font, (String)this.dialogData.getName(21), (int)Math.round((float)(leftPos + 128 - 2) / 0.75f), (int)dialogDataTopPos, (int)fontColor);
                Text.drawString((GuiGraphics)guiGraphics, (Font)AdvancedDialogConfigurationScreen.this.font, (String)this.dialogData.getText(17), (int)Math.round((float)(leftPos + 224 + 14) / 0.75f), (int)dialogDataTopPos, (int)fontColor);
                guiGraphics.pose().popPose();
                int listLeft = AdvancedDialogConfigurationScreen.this.leftPos + 4;
                int listRight = AdvancedDialogConfigurationScreen.this.leftPos + 224 + 96 + 4;
                guiGraphics.fill(listLeft, top + 17, listRight, top + 18, -5592406);
            }
        }
    }
}

