/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.dialog;

import de.markusbordihn.easynpc.client.screen.components.CancelButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.configuration.dialog.DialogConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogType;
import de.markusbordihn.easynpc.data.dialog.DialogUtils;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class YesNoDialogConfigurationScreen<T extends ConfigurationMenu>
extends DialogConfigurationScreen<T> {
    private static final String YES_BUTTON_LABEL = "yes_button";
    private static final String NO_BUTTON_LABEL = "no_button";
    protected EditBox mainDialogBox;
    protected Button yesDialogButton;
    protected Button noDialogButton;
    protected EditBox yesDialogBox;
    protected EditBox noDialogBox;
    protected Button saveButton = null;
    protected Button cancelButton = null;
    boolean showSaveNotificationForButtons = false;
    private String noDialogValue = "";
    private String questionDialogValue = "";
    private String yesDialogValue = "";

    public YesNoDialogConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        DialogDataEntry basicDialog;
        super.init();
        this.yesNoDialogButton.active = false;
        DialogDataEntry questionDialogData = this.getDialogDataSet().getDialog("question");
        DialogDataEntry yesDialogData = this.getDialogDataSet().getDialog("yes_answer");
        DialogDataEntry noDialogData = this.getDialogDataSet().getDialog("no_answer");
        DialogButtonEntry yesButtonData = questionDialogData == null ? null : questionDialogData.getDialogButton(YES_BUTTON_LABEL);
        DialogButtonEntry noButtonData = questionDialogData == null ? null : questionDialogData.getDialogButton(NO_BUTTON_LABEL);
        String string = this.questionDialogValue = questionDialogData == null ? "" : questionDialogData.getText();
        if (this.questionDialogValue.isEmpty() && this.getDialogDataSet().getType() == DialogType.BASIC && (basicDialog = (DialogDataEntry)this.getDialogDataSet().getDialogsByLabel().stream().findFirst().orElse(null)) != null) {
            this.questionDialogValue = basicDialog.getText();
        }
        if (questionDialogData == null) {
            this.showSaveNotificationForButtons = true;
        }
        this.mainDialogBox = new TextField(this.font, this.contentLeftPos, this.topPos + 50, 300);
        this.mainDialogBox.setMaxLength(512);
        this.mainDialogBox.setValue(this.questionDialogValue);
        this.addRenderableWidget((GuiEventListener)this.mainDialogBox);
        this.yesDialogButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos, this.topPos + 85, 145, (Component)(yesButtonData == null ? TextComponent.getText((String)"Yes Button") : yesButtonData.getButtonName(20)), onPress -> {
            UUID yesButtonId;
            UUID uUID = yesButtonId = yesButtonData == null ? null : yesButtonData.id();
            if (questionDialogData != null) {
                if (yesButtonId != null) {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId(), yesButtonId);
                } else {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId());
                }
            }
        }));
        this.noDialogButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.contentLeftPos + 155, this.topPos + 85, 145, (Component)(noButtonData == null ? TextComponent.getText((String)"No Button") : noButtonData.getButtonName(20)), onPress -> {
            UUID noButtonId;
            UUID uUID = noButtonId = noButtonData == null ? null : noButtonData.id();
            if (questionDialogData != null) {
                if (noButtonId != null) {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId(), noButtonId);
                } else {
                    NetworkMessageHandlerManager.getServerHandler().openDialogButtonEditor(this.getEasyNPCUUID(), questionDialogData.getId());
                }
            }
        }));
        this.yesDialogValue = yesDialogData == null ? "" : yesDialogData.getText();
        this.yesDialogBox = new TextField(this.font, this.contentLeftPos, this.topPos + 130, 300);
        this.yesDialogBox.setMaxLength(255);
        this.yesDialogBox.setValue(this.yesDialogValue);
        this.addRenderableWidget((GuiEventListener)this.yesDialogBox);
        this.noDialogValue = noDialogData == null ? "" : noDialogData.getText();
        this.noDialogBox = new TextField(this.font, this.contentLeftPos, this.topPos + 170, 300);
        this.noDialogBox.setMaxLength(255);
        this.noDialogBox.setValue(this.noDialogValue);
        this.addRenderableWidget((GuiEventListener)this.noDialogBox);
        this.saveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.contentLeftPos + 26, this.bottomPos - 40, "save", onPress -> {
            DialogDataSet dialogDataSet = DialogUtils.getYesNoDialog((String)this.mainDialogBox.getValue(), (String)"Yes", (String)"No", (String)this.yesDialogBox.getValue(), (String)this.noDialogBox.getValue());
            if (questionDialogData != null) {
                Set dialogButtonEntrySet = questionDialogData.getDialogButtons();
                if (!questionDialogData.hasDialogButton(YES_BUTTON_LABEL)) {
                    dialogButtonEntrySet.add(dialogDataSet.getDialog("question").getDialogButton(YES_BUTTON_LABEL));
                }
                if (!questionDialogData.hasDialogButton(NO_BUTTON_LABEL)) {
                    dialogButtonEntrySet.add(dialogDataSet.getDialog("question").getDialogButton(NO_BUTTON_LABEL));
                }
                dialogDataSet.getDialog("question").setDialogButtons(dialogButtonEntrySet);
            }
            this.questionDialogValue = this.mainDialogBox.getValue();
            this.yesDialogValue = this.yesDialogBox.getValue();
            this.noDialogValue = this.noDialogBox.getValue();
            NetworkMessageHandlerManager.getServerHandler().saveDialogSet(this.getEasyNPCUUID(), dialogDataSet);
            NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.YES_NO_DIALOG);
        }));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new CancelButton(this.rightPos - 130, this.bottomPos - 40, "cancel", onPress -> this.showMainScreen()));
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"question", (int)this.contentLeftPos, (int)(this.topPos + 40));
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"edit_yes_button", (int)this.contentLeftPos, (int)(this.topPos + 75));
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"edit_no_button", (int)(this.contentLeftPos + 155), (int)(this.topPos + 75));
        if (this.yesDialogBox != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"yes_answer", (int)this.contentLeftPos, (int)(this.yesDialogBox.getY() - 12));
        }
        if (this.noDialogBox != null) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"no_answer", (int)this.contentLeftPos, (int)(this.noDialogBox.getY() - 12));
        }
        if (this.showSaveNotificationForButtons) {
            Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)"save_before_edit_buttons", (int)(this.contentLeftPos + 65), (int)(this.topPos + 105), (int)0xFF5555);
        }
    }

    public void updateTick() {
        super.updateTick();
        if (this.saveButton != null) {
            boolean bl = this.saveButton.active = !this.mainDialogBox.getValue().equals(this.questionDialogValue) || !this.yesDialogBox.getValue().equals(this.yesDialogValue) || !this.noDialogBox.getValue().equals(this.noDialogValue);
        }
        if (this.yesDialogButton != null && this.getDialogDataSet() != null) {
            boolean bl = this.yesDialogButton.active = this.getDialogDataSet().hasDialog("question") && this.getDialogDataSet().getDialog("question").hasDialogButton(YES_BUTTON_LABEL);
        }
        if (this.noDialogButton != null && this.getDialogDataSet() != null) {
            this.noDialogButton.active = this.getDialogDataSet().hasDialog("question") && this.getDialogDataSet().getDialog("question").hasDialogButton(NO_BUTTON_LABEL);
        }
    }
}

