/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.condition.ConditionDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenConditionDataEntryEditorMessage(UUID uuid, UUID dialogId, ConditionDataEntry conditionDataEntry) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"open_condition_data_entry_editor");
    public static final CustomPacketPayload.Type<OpenConditionDataEntryEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenConditionDataEntryEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenConditionDataEntryEditorMessage::create);

    public static OpenConditionDataEntryEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenConditionDataEntryEditorMessage(buffer.readUUID(), buffer.readUUID(), new ConditionDataEntry(buffer.readNbt()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
        CompoundTag compoundTag = new CompoundTag();
        this.conditionDataEntry.write(compoundTag);
        buffer.writeNbt((Tag)compoundTag);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        MenuManager.getMenuHandler().openEditorMenu(EditorType.CONDITION_DATA_ENTRY, serverPlayer, easyNPC, this.dialogId, Constants.EMPTY_UUID, null, this.conditionDataEntry.getId(), 0, new CompoundTag());
    }
}

