/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenDialogEditorMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"open_dialog_editor");
    public static final CustomPacketPayload.Type<OpenDialogEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenDialogEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenDialogEditorMessage::create);

    public static OpenDialogEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenDialogEditorMessage(buffer.readUUID(), buffer.readUUID());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        UUID newDialogId = this.dialogId;
        if (this.dialogId.equals(EMPTY_UUID)) {
            String dialogName = dialogData.getDialogDataSet().hasDialog() ? "Dialog " + RANDOM.nextInt(1000) : "Default";
            DialogDataEntry newDialogData = new DialogDataEntry(dialogName);
            log.info("Create new dialog {} for {} from {}", (Object)newDialogData, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().addDialog(newDialogData);
            newDialogId = newDialogData.getId();
        } else if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", (Object)easyNPC, (Object)dialogData.getDialogDataSet());
            return;
        }
        log.info("Open dialog editor with for dialog {} for {} from {}", (Object)newDialogId, (Object)easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG, serverPlayer, easyNPC, newDialogId, 0);
    }
}

