/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.data.editor.EditorType;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenDialogTextEditorMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"open_dialog_text_editor");
    public static final CustomPacketPayload.Type<OpenDialogTextEditorMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenDialogTextEditorMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), OpenDialogTextEditorMessage::create);

    public static OpenDialogTextEditorMessage create(FriendlyByteBuf buffer) {
        return new OpenDialogTextEditorMessage(buffer.readUUID(), buffer.readUUID());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUUID(this.dialogId);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", (Object)easyNPC, (Object)dialogData.getDialogDataSet());
            return;
        }
        log.info("Open dialog editor with for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG_TEXT, serverPlayer, easyNPC, this.dialogId, 0);
    }
}

