/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.saveddata.ActionExecutionTracker;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public record ResetExecutionLimitMessage(UUID dialogId, boolean allPlayers) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"reset_execution_limit");
    public static final CustomPacketPayload.Type<ResetExecutionLimitMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ResetExecutionLimitMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ResetExecutionLimitMessage::create);

    public static ResetExecutionLimitMessage create(FriendlyByteBuf buffer) {
        return new ResetExecutionLimitMessage(buffer.readUUID(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.dialogId);
        buffer.writeBoolean(this.allPlayers);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        if (this.dialogId == null) {
            return;
        }
        ActionExecutionTracker tracker = ActionExecutionTracker.get((ServerLevel)serverPlayer.serverLevel());
        if (this.allPlayers) {
            if (!serverPlayer.hasPermissions(2)) {
                log.warn("Player {} tried to reset executions for all players without permission", (Object)serverPlayer.getName().getString());
                return;
            }
            tracker.resetExecutionForAllPlayers(this.dialogId);
            log.info("Player {} reset execution limit for all players for dialog {}", (Object)serverPlayer.getName().getString(), (Object)this.dialogId);
        } else {
            tracker.resetExecution(serverPlayer.getUUID(), this.dialogId);
            log.debug("Player {} reset execution limit for dialog {}", (Object)serverPlayer.getName().getString(), (Object)this.dialogId);
        }
    }
}

