/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu;

import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenuHandler;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenuHandler;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationTypeHelper;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.MenuType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    default public void openConfigurationMenu(ConfigurationType configurationType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        if (!AccessManager.hasAccess((ServerPlayer)serverPlayer, easyNPC)) {
            return;
        }
        ConfigurationType configurationTypeAlias = ConfigurationTypeHelper.resolveConfigurationTypeAlias((ConfigurationType)configurationType, easyNPC);
        MenuType<? extends ConfigurationMenu> menuType = this.getMenuTypeByConfigurationType(configurationTypeAlias);
        if (menuType == null) {
            log.error("Unknown configuration {} for {} from {}", (Object)configurationTypeAlias, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = ConfigurationMenuHandler.getScreenData(configurationTypeAlias, easyNPC, serverPlayer, pageIndex);
        MenuProvider menuProvider = ConfigurationMenuHandler.getMenuProvider(configurationTypeAlias, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, ActionEventType actionEventType, ConfigurationType configurationType, EditorType formerEditorType, int pageIndex) {
        if (!AccessManager.hasAccess((ServerPlayer)serverPlayer, easyNPC)) {
            return;
        }
        CompoundTag additionalSyncData = new CompoundTag();
        AdditionalScreenData.addActionEventType((CompoundTag)additionalSyncData, (ActionEventType)actionEventType);
        AdditionalScreenData.addConfigurationType((CompoundTag)additionalSyncData, (ConfigurationType)configurationType);
        AdditionalScreenData.addEditorType((CompoundTag)additionalSyncData, (EditorType)formerEditorType);
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, null, null, pageIndex, new CompoundTag());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, null, pageIndex, new CompoundTag());
    }

    default public void openEditorMenu(EditorType editorType, ServerPlayer serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, CompoundTag additionalSyncData) {
        if (!AccessManager.hasAccess((ServerPlayer)serverPlayer, easyNPC)) {
            return;
        }
        MenuType<? extends EditorMenu> menuType = this.getMenuTypeByEditorType(editorType);
        if (menuType == null) {
            log.error("Unknown editor {} for {} from {}", (Object)editorType, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = EditorMenuHandler.getScreenData(editorType, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
        MenuProvider menuProvider = EditorMenuHandler.getMenuProvider(editorType, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    public MenuType<? extends ConfigurationMenu> getMenuTypeByConfigurationType(ConfigurationType var1);

    public MenuType<? extends EditorMenu> getMenuTypeByEditorType(EditorType var1);
}

