/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.attribute.EntityAttribute;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean booleanValue, Float floatValue, Integer integerValue, String stringValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_entity_attribute");

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Boolean value) {
        this(uuid, entityAttribute, value, Float.valueOf(0.0f), 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Float value) {
        this(uuid, entityAttribute, false, value, 0, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, Integer value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), value, "");
    }

    public ChangeEntityAttributeMessage(UUID uuid, EntityAttribute entityAttribute, String value) {
        this(uuid, entityAttribute, false, Float.valueOf(0.0f), 0, value);
    }

    public static ChangeEntityAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeEntityAttributeMessage(buffer.m_130259_(), (EntityAttribute)buffer.m_130066_(EntityAttribute.class), buffer.readBoolean(), Float.valueOf(buffer.readFloat()), buffer.readInt(), buffer.m_130277_());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.entityAttribute);
        buffer.writeBoolean(this.booleanValue.booleanValue());
        buffer.writeFloat(this.floatValue.floatValue());
        buffer.writeInt(this.integerValue.intValue());
        buffer.m_130070_(this.stringValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.entityAttribute == null) {
            log.error("Invalid entity attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.booleanValue == null && this.floatValue == null && this.integerValue == null && this.stringValue == null) {
            log.error("Invalid value for {} for {} from {}", (Object)this.entityAttribute, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        boolean successfullyChanged = false;
        if (this.booleanValue != null) {
            successfullyChanged = AttributeHandler.setEntityAttribute((EasyNPC)easyNPC, (EntityAttribute)this.entityAttribute, (boolean)this.booleanValue);
        }
        if (!successfullyChanged) {
            log.error("Unable to change entity attribute {} for {} from {}", (Object)this.entityAttribute, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

