/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeEntityBaseAttributeMessage(UUID uuid, ResourceLocation attribute, Double value) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_entity_base_attribute");

    public static ChangeEntityBaseAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeEntityBaseAttributeMessage(buffer.m_130259_(), buffer.m_130281_(), buffer.readDouble());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130085_(this.attribute);
        buffer.writeDouble(this.value.doubleValue());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.attribute == null) {
            log.error("Invalid base attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.value == null) {
            log.error("Invalid value for base attribute {} for {} from {}", (Object)this.attribute, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!AttributeHandler.setBaseAttribute((EasyNPC)easyNPC, (ResourceLocation)this.attribute, (Double)this.value)) {
            log.error("Unable to set base attribute {} for {} from {}", (Object)this.attribute, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

