/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeTradingTypeMessage(UUID uuid, TradingType tradingType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_trading_type");

    public static ChangeTradingTypeMessage create(FriendlyByteBuf buffer) {
        return new ChangeTradingTypeMessage(buffer.m_130259_(), (TradingType)buffer.m_130066_(TradingType.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.tradingType);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingType == null) {
            log.error("Invalid trading type for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Invalid trading data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change trading type: {} for {} from {}", (Object)this.tradingType, (Object)easyNPC, (Object)serverPlayer);
        tradingData.getTradingDataSet().setType(this.tradingType);
        tradingData.updateTradingDataSet();
    }
}

