/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record OpenConfigurationMessage(UUID uuid, ConfigurationType configurationType, int pageIndex) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"open_configuration_screen");
    public static final class_8710.class_9154<OpenConfigurationMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, OpenConfigurationMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), OpenConfigurationMessage::create);

    public static OpenConfigurationMessage create(class_2540 buffer) {
        return new OpenConfigurationMessage(buffer.method_10790(), (ConfigurationType)buffer.method_10818(ConfigurationType.class), buffer.readInt());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10817((Enum)this.configurationType);
        buffer.method_53002(this.pageIndex);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.configurationType == null) {
            log.error("Invalid configuration type for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)this.pageIndex, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        MenuManager.getMenuHandler().openConfigurationMenu(this.configurationType, serverPlayer, easyNPC, this.pageIndex);
    }
}

