/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ImportPresetConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static class_2960 selectedPreset;
    protected static List<class_2960> presetList;
    protected class_4185 localImportPresetButton;
    protected class_4185 customImportPresetButton;
    protected class_4185 defaultImportPresetButton;
    protected class_4185 worldImportPresetButton;
    protected String importPresetButtonLabel = "import_preset";
    protected String importPresetHeaderLabel = "import_preset_header";
    protected class_4185 importPresetButton;
    ImportFileSelectionList presetSelectionList;

    public ImportPresetConfigurationScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
    }

    public static void updateSelectedPreset(class_2960 resourceLocation) {
        selectedPreset = resourceLocation;
    }

    public static void updatePresets(List<class_2960> presets) {
        presetList = presets;
    }

    public static List<class_2960> getPresets() {
        return presetList;
    }

    public static boolean hasNoPresets() {
        return presetList == null || presetList.isEmpty();
    }

    public void loadPresetConfirm(class_2960 resourceLocation) {
        class_310 minecraft = this.field_22787;
        if (minecraft == null) {
            return;
        }
        minecraft.method_1507((class_437)new class_410(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                this.loadPreset(resourceLocation);
                minecraft.method_1507(null);
            } else {
                minecraft.method_1507((class_437)this);
            }
        }, (class_2561)TextComponent.getTranslatedConfigText((String)"preset.importQuestion", (String)resourceLocation.method_12832().substring(resourceLocation.method_12832().lastIndexOf("/") + 1)), (class_2561)TextComponent.getTranslatedConfigText((String)"preset.importWarning", (String)this.getEasyNPCEntity().method_5476().getString()), (class_2561)TextComponent.getTranslatedConfigText((String)"preset.importButton"), class_5244.field_24335));
    }

    public void loadPreset(class_2960 resourceLocation) {
        log.error("Not implemented! Received resource location {}", (Object)resourceLocation);
    }

    public String getPresetFileName(class_2960 resourceLocation) {
        this.getSkinModel();
        return resourceLocation.method_12832().replace("preset/" + this.getSkinModel().toString().toLowerCase(Locale.ROOT) + "/", "").replace(".npc.nbt", "");
    }

    @Override
    public void method_25426() {
        super.method_25426();
        int buttonWidth = 70;
        this.localImportPresetButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth - 4, "local", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.LOCAL_PRESET_IMPORT)));
        this.defaultImportPresetButton = (class_4185)this.method_37063((class_364)new TextButton(this.localImportPresetButton.method_46426() + this.localImportPresetButton.method_25368(), this.buttonTopPos, buttonWidth - 4, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        this.worldImportPresetButton = (class_4185)this.method_37063((class_364)new TextButton(this.defaultImportPresetButton.method_46426() + this.defaultImportPresetButton.method_25368(), this.buttonTopPos, buttonWidth - 6, "world_preset", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.WORLD_PRESET_IMPORT)));
        this.customImportPresetButton = (class_4185)this.method_37063((class_364)new TextButton(this.worldImportPresetButton.method_46426() + this.worldImportPresetButton.method_25368(), this.buttonTopPos, buttonWidth + 15, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_IMPORT)));
        this.importPresetButton = (class_4185)this.method_37063((class_364)new TextButton(this.buttonLeftPos + 25, this.bottomPos - 40, 220, this.importPresetButtonLabel, button -> {
            if (selectedPreset != null) {
                this.loadPresetConfirm(selectedPreset);
            }
        }));
        this.presetSelectionList = new ImportFileSelectionList(this.field_22787);
        this.method_25429((class_364)this.presetSelectionList);
        ImportPresetConfigurationScreen.updateSelectedPreset(null);
    }

    public void method_25394(class_332 guiGraphics, int x, int y, float partialTicks) {
        super.method_25394(guiGraphics, x, y, partialTicks);
        if (this.presetSelectionList != null) {
            this.presetSelectionList.renderSelectionList(guiGraphics, x, y, partialTicks);
        }
        if (this.importPresetButton != null) {
            this.importPresetButton.field_22763 = selectedPreset != null;
        }
    }

    protected void renderBg(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int fileListTop = this.topPos + 55;
        int fileListHeight = fileListTop + 110;
        int fileListWidth = this.leftPos + 290;
        guiGraphics.method_25294(this.contentLeftPos - 1, fileListTop - 1, fileListWidth + 1, fileListHeight + 1, -16777216);
        guiGraphics.method_25294(this.contentLeftPos, fileListTop, fileListWidth, fileListHeight, -5592406);
    }

    class ImportFileSelectionList
    extends class_4280<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
        public ImportFileSelectionList(class_310 minecraft) {
            super(minecraft, ImportPresetConfigurationScreen.this.field_22789 - 22, 95, ImportPresetConfigurationScreen.this.contentTopPos + 47, 14);
            this.updatePresets();
        }

        public void updatePresets() {
            this.method_25339();
            if (ImportPresetConfigurationScreen.hasNoPresets()) {
                return;
            }
            ImportPresetConfigurationScreen.getPresets().forEach(resourceLocation -> {
                Entry entry = new Entry((class_2960)resourceLocation, ImportPresetConfigurationScreen.this.getSkinModel());
                this.method_25321((class_350.class_351)entry);
            });
        }

        protected void method_57713(class_332 guiGraphics) {
        }

        protected void method_57715(class_332 guiGraphics) {
        }

        protected int method_65508() {
            return super.method_65508() + 12;
        }

        public int method_25322() {
            return super.method_25322() + 40;
        }

        public boolean method_25370() {
            return ImportPresetConfigurationScreen.this.method_25399() == this;
        }

        public void renderSelectionList(class_332 guiGraphics, int x, int y, float partialTicks) {
            if (this.method_25340() > 0) {
                super.method_25394(guiGraphics, x, y, partialTicks);
                return;
            }
            Text.drawConfigStringShadow((class_332)guiGraphics, (class_327)ImportPresetConfigurationScreen.this.field_22793, (String)"no_presets_found", (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 80), (int)(ImportPresetConfigurationScreen.this.topPos + 105), (int)0xFFFFFF);
        }

        public class Entry
        extends class_4280.class_4281<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
            final class_2960 resourceLocation;
            final SkinModel skinModel;
            final String fileName;

            public Entry(class_2960 resourceLocation, SkinModel skinModel) {
                this.resourceLocation = resourceLocation;
                this.skinModel = skinModel;
                this.fileName = ImportPresetConfigurationScreen.this.getPresetFileName(resourceLocation);
            }

            public void method_25343(class_332 guiGraphics, int x, int y, int unused1, int unused2, int unused3, int unused4, int unused5, boolean unused6, float partialTicks) {
                int fileListTop = ImportPresetConfigurationScreen.this.topPos + 55;
                int fileListWidth = ImportPresetConfigurationScreen.this.leftPos + 290;
                guiGraphics.method_25294(ImportPresetConfigurationScreen.this.contentLeftPos - 1, fileListTop - 4, fileListWidth + 1, fileListTop + 12, -16777216);
                guiGraphics.method_25294(ImportPresetConfigurationScreen.this.contentLeftPos, fileListTop - 3, fileListWidth, fileListTop + 11, -7829368);
                Text.drawConfigStringShadowWithData((class_332)guiGraphics, (class_327)ImportPresetConfigurationScreen.this.field_22793, (String)ImportPresetConfigurationScreen.this.importPresetHeaderLabel, (String)this.skinModel.getName(), (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 3), (int)fileListTop, (int)0xFFFFFF);
                Text.drawStringShadow((class_332)guiGraphics, (class_327)ImportPresetConfigurationScreen.this.field_22793, (String)this.fileName, (int)(ImportFileSelectionList.this.field_22758 / 2 - ImportPresetConfigurationScreen.this.field_22793.method_1727(this.fileName) / 2), (int)(y + 1), (int)0xFFFFFF);
            }

            public boolean method_25402(double unused1, double unused2, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ImportFileSelectionList.this.method_25313((class_350.class_351)this);
                log.debug("Selected file {}.", (Object)this.resourceLocation);
                ImportPresetConfigurationScreen.updateSelectedPreset(this.resourceLocation);
            }

            public class_2561 method_37006() {
                return TextComponent.getText((String)this.resourceLocation.method_12832());
            }
        }
    }
}

