/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.position;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.configuration.position.PositionConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributeType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.phys.Vec3;

public class DefaultPositionConfigurationScreen<T extends ConfigurationMenu>
extends PositionConfigurationScreen<T> {
    private static final float POSITION_STEPS = 0.5f;
    protected EditBox positionXBox;
    protected EditBox positionYBox;
    protected EditBox positionZBox;
    protected Checkbox positionFreefallCheckbox;
    protected double positionX = 0.0;
    protected double positionY = 0.0;
    protected double positionZ = 0.0;
    protected Button positionXMinusButton;
    protected Button positionXPlusButton;
    protected Button positionYMinusButton;
    protected Button positionYPlusButton;
    protected Button positionZMinusButton;
    protected Button positionZPlusButton;

    public DefaultPositionConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
        this.renderBackground = false;
    }

    @Override
    public void init() {
        super.init();
        this.defaultPositionButton.active = false;
        Vec3 entityPosition = this.getEasyNPCEntity().position();
        this.positionX = entityPosition.x;
        this.positionY = entityPosition.y;
        this.positionZ = entityPosition.z;
        int positionTopPos = this.contentTopPos + 10;
        this.positionXBox = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, this.contentLeftPos + 15, positionTopPos, 60));
        this.positionXBox.setMaxLength(8);
        this.positionXBox.setValue(String.valueOf(this.positionX));
        this.positionXBox.setResponder(consumer -> {
            this.positionX = ValueUtils.getDoubleValue((String)this.positionXBox.getValue());
            NetworkMessageHandlerManager.getServerHandler().positionChange(this.getEasyNPCUUID(), new Vec3(this.positionX, this.positionY, this.positionZ));
        });
        this.positionXMinusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionXBox.getX() - 15, this.positionXBox.getY(), 15, "-", button -> {
            this.positionX -= 0.5;
            this.positionXBox.setValue(String.valueOf(this.positionX));
        }));
        this.positionXPlusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionXBox.getX() + this.positionXBox.getWidth() + 1, this.positionXBox.getY(), 15, "+", button -> {
            this.positionX += 0.5;
            this.positionXBox.setValue(String.valueOf(this.positionX));
        }));
        this.positionYBox = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, this.contentLeftPos + 111, positionTopPos, 60));
        this.positionYBox.setMaxLength(8);
        this.positionYBox.setValue(String.valueOf(this.positionY));
        this.positionYBox.setResponder(consumer -> {
            this.positionY = ValueUtils.getDoubleValue((String)this.positionYBox.getValue());
            NetworkMessageHandlerManager.getServerHandler().positionChange(this.getEasyNPCUUID(), new Vec3(this.positionX, this.positionY, this.positionZ));
        });
        this.positionYMinusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionYBox.getX() - 15, this.positionYBox.getY(), 15, (Component)TextComponent.getText((String)"-"), button -> {
            this.positionY -= 0.5;
            this.positionYBox.setValue(String.valueOf(this.positionY));
        }));
        this.positionYPlusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionYBox.getX() + this.positionYBox.getWidth() + 1, this.positionYBox.getY(), 15, (Component)TextComponent.getText((String)"+"), button -> {
            this.positionY += 0.5;
            this.positionYBox.setValue(String.valueOf(this.positionY));
        }));
        this.positionZBox = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, this.contentLeftPos + 207, positionTopPos, 60));
        this.positionZBox.setMaxLength(8);
        this.positionZBox.setValue(String.valueOf(this.positionZ));
        this.positionZBox.setResponder(consumer -> {
            this.positionZ = ValueUtils.getDoubleValue((String)this.positionZBox.getValue());
            NetworkMessageHandlerManager.getServerHandler().positionChange(this.getEasyNPCUUID(), new Vec3(this.positionX, this.positionY, this.positionZ));
        });
        this.positionZMinusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionZBox.getX() - 15, this.positionZBox.getY(), 15, (Component)TextComponent.getText((String)"-"), button -> {
            this.positionZ -= 0.5;
            this.positionZBox.setValue(String.valueOf(this.positionZ));
        }));
        this.positionZPlusButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.positionZBox.getX() + this.positionZBox.getWidth() + 1, this.positionZBox.getY(), 15, (Component)TextComponent.getText((String)"+"), button -> {
            this.positionZ += 0.5;
            this.positionZBox.setValue(String.valueOf(this.positionZ));
        }));
        EntityAttributes attributeData = this.getEasyNPC().getEasyNPCAttributeData().getEntityAttributes();
        this.positionFreefallCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(this.contentLeftPos + 200, positionTopPos + 20, "free_fall", attributeData.getEnvironmentalAttributes().freefall(), checkbox -> NetworkMessageHandlerManager.getServerHandler().environmentalAttributeChange(this.getEasyNPCUUID(), EnvironmentalAttributeType.FREEFALL, checkbox.selected())));
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Position X", (int)(this.positionXBox.getX() + 5), (int)(this.positionXBox.getY() - 10));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Position Y", (int)(this.positionYBox.getX() + 5), (int)(this.positionYBox.getY() - 10));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)"Position Z", (int)(this.positionZBox.getX() + 5), (int)(this.positionZBox.getY() - 10));
    }
}

