/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.scaling;

import de.markusbordihn.easynpc.client.screen.components.RangeSliderButton;
import de.markusbordihn.easynpc.client.screen.components.SliderButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScalingConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    private static final int DIMENSION_UPDATE_TICK = 20;
    protected Button defaultScaleButton;
    protected RangeSliderButton scaleXSliderButton;
    protected RangeSliderButton scaleYSliderButton;
    protected RangeSliderButton scaleZSliderButton;
    private int dimensionUpdateTicker = 0;

    public ScalingConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        int buttonWidth = 80;
        this.defaultScaleButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "scaling", button -> {}));
        this.defaultScaleButton.active = false;
        int scalePositionLeft = this.contentLeftPos + 165;
        int scalePositionTop = this.contentTopPos + 20;
        int scalePositionSpace = 60;
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        CustomScale rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
        this.scaleXSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)this.createScaleSlider(scalePositionLeft, scalePositionTop, rootScale.x(), slider -> this.updateModelScale()));
        this.scaleYSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)this.createScaleSlider(scalePositionLeft, scalePositionTop + scalePositionSpace, rootScale.y(), slider -> this.updateModelScale()));
        this.scaleZSliderButton = (RangeSliderButton)this.addRenderableWidget((GuiEventListener)this.createScaleSlider(scalePositionLeft, scalePositionTop + scalePositionSpace * 2, rootScale.z(), slider -> this.updateModelScale()));
    }

    private RangeSliderButton createScaleSlider(int x, int y, float currentValue, Consumer<SliderButton> onChange) {
        return new RangeSliderButton(x, y, 140, 20, (double)currentValue, 1.0, SliderButton.Type.SCALE, onChange::accept);
    }

    private void drawScaleLabel(GuiGraphics guiGraphics, String key, RangeSliderButton slider) {
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)key, (int)slider.getX(), (int)(slider.getY() - 10));
    }

    private void updateModelScale() {
        NetworkMessageHandlerManager.getServerHandler().modelScaleChange(this.getEasyNPCUUID(), ModelPartType.ROOT, new CustomScale(this.scaleXSliderButton.getTargetValue(), this.scaleYSliderButton.getTargetValue(), this.scaleZSliderButton.getTargetValue()));
    }

    public void updateTick() {
        super.updateTick();
        if (this.getEasyNPCEntity() != null && this.dimensionUpdateTicker++ > 20) {
            this.getEasyNPCEntity().refreshDimensions();
            this.dimensionUpdateTicker = 0;
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        ScreenHelper.renderEntityAvatarForScaling((GuiGraphics)guiGraphics, (int)(this.contentLeftPos + 80), (int)(this.contentTopPos + 192), (int)30, (float)((float)(this.contentLeftPos + 75) - this.xMouse), (float)((float)(this.contentTopPos + 120) - this.yMouse), (EasyNPC)this.getEasyNPC());
        this.drawScaleLabel(guiGraphics, "scale_x", this.scaleXSliderButton);
        this.drawScaleLabel(guiGraphics, "scale_y", this.scaleYSliderButton);
        this.drawScaleLabel(guiGraphics, "scale_z", this.scaleZSliderButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        String[] scaleValues;
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.fill(this.contentLeftPos, this.contentTopPos, this.contentLeftPos + 159, this.contentTopPos + 207, -16777216);
        guiGraphics.fill(this.contentLeftPos + 1, this.contentTopPos + 1, this.contentLeftPos + 158, this.contentTopPos + 206, -5592406);
        int scaleLinesColor = -1437248171;
        int scaleLinesTop = this.contentTopPos + 193;
        int scaleLinesLeft = this.contentLeftPos + 4;
        for (String scaleValue : scaleValues = new String[]{"  0", "0.5", "1.0", "1.5", "2.0", "2.5", "3.0"}) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)scaleValue, (int)scaleLinesLeft, (int)(scaleLinesTop - 4), (int)scaleLinesColor);
            guiGraphics.fill(this.contentLeftPos + 20, scaleLinesTop - 1, this.contentLeftPos + 152, scaleLinesTop, scaleLinesColor);
            scaleLinesTop -= 31;
        }
    }
}

