/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu;

import de.markusbordihn.easynpc.configui.menu.MenuHandlerInterface;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static final Map<UUID, class_3908> menuProviderMap = new ConcurrentHashMap<UUID, class_3908>();
    private static final Map<UUID, class_3222> serverPlayerMap = new ConcurrentHashMap<UUID, class_3222>();
    private static final Map<UUID, UUID> menuNpcMap = new ConcurrentHashMap<UUID, UUID>();
    private static MenuHandlerInterface menuHandlerInterface;

    private MenuManager() {
    }

    public static void registerMenuHandler(MenuHandlerInterface menuHandler) {
        menuHandlerInterface = menuHandler;
    }

    public static MenuHandlerInterface getMenuHandler() {
        return menuHandlerInterface;
    }

    public static UUID registerMenu(UUID uuid, class_3908 menuProvider, class_3222 serverPlayer) {
        UUID menuId = UUID.randomUUID();
        menuProviderMap.put(menuId, menuProvider);
        serverPlayerMap.put(menuId, serverPlayer);
        menuNpcMap.put(menuId, uuid);
        return menuId;
    }

    public static void openMenu(UUID npcUUID, class_3908 menuProvider, class_3222 serverPlayer, class_2487 data) {
        UUID menuId = UUID.randomUUID();
        menuProviderMap.put(menuId, menuProvider);
        serverPlayerMap.put(menuId, serverPlayer);
        menuNpcMap.put(menuId, npcUUID);
        NetworkMessageHandlerManager.getClientHandler().openMenu(npcUUID, menuId, serverPlayer, data);
    }

    public static void openMenu(UUID menuId, class_3222 serverPlayer) {
        class_3222 menuServerPlayer = serverPlayerMap.get(menuId);
        if (menuServerPlayer == null || !menuServerPlayer.equals((Object)serverPlayer)) {
            log.error("Invalid server player ({} != {}) for menu {}", (Object)serverPlayer, (Object)menuServerPlayer, (Object)menuId);
            return;
        }
        class_3908 menuProvider = menuProviderMap.get(menuId);
        if (menuProvider == null) {
            log.error("Invalid menu provider for menu {}", (Object)menuId);
            return;
        }
        UUID npcUUID = menuNpcMap.get(menuId);
        if (npcUUID == null) {
            log.error("Invalid NPC UUID for menu {}", (Object)menuId);
            return;
        }
        log.debug("Opening menu {} for npc {} and player {} with {}", (Object)menuId, (Object)npcUUID, (Object)serverPlayer, (Object)menuProvider);
        OptionalInt dialogId = serverPlayer.method_17355(menuProvider);
        if (dialogId.isPresent()) {
            log.debug("Clean menu {} ({}) data with {} for {}", (Object)menuId, (Object)dialogId.getAsInt(), (Object)menuProvider, (Object)serverPlayer);
            menuProviderMap.remove(menuId);
            serverPlayerMap.remove(menuId);
        } else {
            log.error("Got invalid dialog ID for menu {}", (Object)menuId);
        }
    }
}

