/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.main;

import de.markusbordihn.easynpc.client.screen.components.ColorButton;
import de.markusbordihn.easynpc.client.screen.components.CopyButton;
import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.components.NameVisibilityToggleButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;

public class MainConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    public static final int BUTTON_HEIGHT = 18;
    public static final int BUTTON_WIDTH = 97;
    private static final Map<String, ConfigurationType> menuButtons = new LinkedHashMap<String, ConfigurationType>();
    private Button copyUUIDButton;
    private String formerName = "";
    private int formerTextColor = 0xFFFFFF;
    private NameVisibilityType formerNameVisibility = NameVisibilityType.ALWAYS;
    private EditBox nameBox;
    private ColorButton nameColorButton;
    private NameVisibilityToggleButton nameVisibilityButton;
    private Button saveNameButton;
    private int avatarTopPos;

    public MainConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.showCloseButton = true;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.contentTopPos = this.topPos + 15;
        this.avatarTopPos = this.contentTopPos + 1;
        this.homeButton.f_93624_ = false;
        this.defineNameAndColorBox();
        this.defineImportExportButtons();
        this.defineUUIDButton();
        this.defineRespawnButton();
        this.defineDeleteButton();
        this.defineEditSkinButton();
        this.defineChangeModelButton();
        this.defineMenuButtons();
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        BlockPos blockPos;
        NavigationDataCapable navigationData;
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (this.getEasyNPC() == null) {
            return;
        }
        int scale = this.getEasyNPC().getEasyNPCGuiData().getEntityGuiScaling();
        float rotationYaw = (float)(this.leftPos + 50) - this.xMouse;
        float rotationPitch = (float)(this.contentTopPos + 70) - this.yMouse;
        EntityRenderConfig config = EntityRenderConfig.guiScaled((int)(this.leftPos + 60), (int)(this.avatarTopPos + 140), (int)scale, (float)rotationYaw, (float)rotationPitch);
        EntityScreenRenderer.renderEntity((GuiGraphics)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)config);
        float scaleEntityTypeText = 0.75f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scaleEntityTypeText, scaleEntityTypeText, scaleEntityTypeText);
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("UUID: " + String.valueOf(this.getEasyNPCEntity().m_20148_())), (int)Math.round((float)(this.contentLeftPos + 1) / scaleEntityTypeText), (int)Math.round((float)(this.buttonTopPos + 1) / scaleEntityTypeText));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (Component)this.getEasyNPCEntity().m_6095_().m_20676_(), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 4) / scaleEntityTypeText));
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        OwnerDataCapable ownerData = this.getEasyNPC().getEasyNPCOwnerData();
        if (ownerData != null) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("Owner: " + (ownerData.hasNPCOwner() ? ownerData.getNPCOwnerName() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 15) / scaleEntityTypeText));
        }
        if ((navigationData = this.getEasyNPC().getEasyNPCNavigationData()) != null && navigationData.hasHomePosition()) {
            blockPos = navigationData.getHomePosition();
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("Home: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 23) / scaleEntityTypeText));
        }
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("Team: " + (this.getEasyNPCEntity().m_5647_() != null ? this.getEasyNPCEntity().m_5647_().m_5758_() : "-")), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 31) / scaleEntityTypeText));
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("HP: " + this.getEasyNPCLivingEntity().m_21223_() + "/" + this.getEasyNPCLivingEntity().m_21233_()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 39) / scaleEntityTypeText));
        blockPos = this.getEasyNPCEntity().m_20097_();
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)("Pos: " + blockPos.m_123341_() + ", " + blockPos.m_123342_() + ", " + blockPos.m_123343_()), (int)Math.round((float)(this.contentLeftPos + 3) / scaleEntityTypeText), (int)Math.round((float)(this.avatarTopPos + 147) / scaleEntityTypeText));
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.m_280509_(this.contentLeftPos, this.avatarTopPos, this.leftPos + 117, this.avatarTopPos + 135, -16777216);
        guiGraphics.m_280509_(this.leftPos + 8, this.avatarTopPos + 1, this.leftPos + 116, this.avatarTopPos + 134, -1);
        guiGraphics.m_280509_(this.contentLeftPos, this.avatarTopPos + 12, this.leftPos + 117, this.avatarTopPos + 155, -16777216);
        guiGraphics.m_280509_(this.leftPos + 8, this.avatarTopPos + 13, this.leftPos + 116, this.avatarTopPos + 155, -5592406);
    }

    private void defineImportExportButtons() {
        Button importButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.leftPos + 122, this.contentTopPos + 35, 97, "import", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        importButton.f_93623_ = true;
        Button exportButton = (Button)this.m_142416_((GuiEventListener)new TextButton(importButton.m_252754_() + importButton.m_5711_() + 5, importButton.m_252907_(), 97, "export", onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_EXPORT)));
        exportButton.f_93623_ = true;
    }

    private void defineNameAndColorBox() {
        DisplayAttributeDataCapable displayAttributeData;
        String string;
        Component nameComponent = this.getEasyNPCEntity().m_7755_();
        DyeColor[] dyeColorArray = nameComponent.m_214077_();
        if (dyeColorArray instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)dyeColorArray;
            string = translatableContents.m_237508_();
        } else {
            string = nameComponent.getString();
        }
        this.formerName = string;
        this.nameBox = new TextField(this.f_96547_, this.contentLeftPos + 115, this.contentTopPos + 2, 138);
        this.nameBox.m_94199_(32);
        this.nameBox.m_94144_(this.formerName);
        this.nameBox.m_94151_(consumer -> this.validateName());
        this.m_142416_((GuiEventListener)this.nameBox);
        this.nameColorButton = (ColorButton)this.m_142416_((GuiEventListener)new ColorButton(this.nameBox.m_252754_() + this.nameBox.m_5711_() + 1, this.nameBox.m_252907_() - 1, onPress -> this.validateName()));
        if (this.getEasyNPCEntity().m_8077_() && this.getEasyNPCEntity().m_7770_().m_7383_() != null && this.getEasyNPCEntity().m_7770_().m_7383_().m_131135_() != null) {
            int styleTextColor = this.getEasyNPCEntity().m_7770_().m_7383_().m_131135_().m_131265_();
            for (DyeColor dyeColor : DyeColor.values()) {
                if (dyeColor.m_41071_() != styleTextColor) continue;
                this.nameColorButton.setColor(dyeColor);
                this.formerTextColor = styleTextColor;
                break;
            }
        }
        NameVisibilityType currentVisibility = (displayAttributeData = this.getEasyNPC().getEasyNPCDisplayAttributeData()) != null ? (NameVisibilityType)displayAttributeData.getDisplayEnumAttribute(DisplayAttributeType.NAME_VISIBILITY, NameVisibilityType.class) : NameVisibilityType.ALWAYS;
        this.nameVisibilityButton = (NameVisibilityToggleButton)this.m_142416_((GuiEventListener)new NameVisibilityToggleButton(this.nameColorButton.m_252754_() + this.nameColorButton.m_5711_() + 2, this.nameColorButton.m_252907_(), currentVisibility, (button, newType) -> this.validateName()));
        this.formerNameVisibility = currentVisibility;
        this.saveNameButton = (Button)this.m_142416_((GuiEventListener)new SaveButton(this.nameVisibilityButton.m_252754_() + this.nameVisibilityButton.m_5711_() + 2, this.nameVisibilityButton.m_252907_(), onPress -> this.saveName()));
        this.saveNameButton.f_93623_ = false;
    }

    private void defineUUIDButton() {
        this.copyUUIDButton = (Button)this.m_142416_((GuiEventListener)new CopyButton(this.contentLeftPos, this.bottomPos - 27, 90, "copy_uuid", onPress -> {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91068_.m_90911_(this.getEasyNPCUUID().toString());
        }));
    }

    private void defineRespawnButton() {
        this.m_142416_((GuiEventListener)new ReloadButton(this.copyUUIDButton.m_252754_() + this.copyUUIDButton.m_5711_() + 4, this.bottomPos - 27, 80, 16, "respawn", onPress -> this.respawnNPC()));
    }

    private void defineDeleteButton() {
        this.m_142416_((GuiEventListener)new DeleteButton(this.rightPos - 70, this.bottomPos - 29, 65, onPress -> this.deleteNPC()));
    }

    protected void defineEditSkinButton() {
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        if (skinData == null) {
            return;
        }
        Button editSkinButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 155, 110, 14, "edit_skin", onPress -> {
            SkinType skinType = skinData.getSkinType();
            switch (skinType) {
                case NONE: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.NONE_SKIN);
                    break;
                }
                case PLAYER_SKIN: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.PLAYER_SKIN);
                    break;
                }
                case SECURE_REMOTE_URL: 
                case INSECURE_REMOTE_URL: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.URL_SKIN);
                    break;
                }
                case CUSTOM: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_SKIN);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_SKIN);
                }
            }
        }));
        editSkinButton.f_93623_ = this.supportsConfigurationType(ConfigurationType.SKIN);
    }

    protected void defineChangeModelButton() {
        RenderDataSet renderDataSet = this.getRenderDataSet();
        if (renderDataSet == null) {
            return;
        }
        boolean supportsChangeModel = this.getConfigurationData().supportsChangeModelConfiguration();
        Button changeModelButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos, this.avatarTopPos + 168, 110, 14, "change_model", onPress -> {
            if (!supportsChangeModel) {
                return;
            }
            switch (renderDataSet.getRenderType()) {
                case CUSTOM_ENTITY: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_MODEL);
                    break;
                }
                default: {
                    NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_MODEL);
                }
            }
        }));
        changeModelButton.f_93623_ = supportsChangeModel;
        if (!supportsChangeModel) {
            changeModelButton.m_257544_(Tooltip.m_257550_((Component)TextComponent.getTranslatedConfigText((String)"change_model.tooltip.only_doppler")));
        }
    }

    protected void defineMenuButtons() {
        int buttonTopPos = this.topPos + 75;
        int buttonLeftPos = this.contentLeftPos + 115;
        int buttonIndex = 0;
        for (Map.Entry<String, ConfigurationType> entry : menuButtons.entrySet()) {
            String buttonName = entry.getKey();
            ConfigurationType configurationType = entry.getValue();
            Button button = (Button)this.m_142416_((GuiEventListener)new TextButton(buttonLeftPos + buttonIndex % 2 * 102, buttonTopPos + buttonIndex / 2 * 20, 97, buttonName, onPress -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), configurationType)));
            button.f_93623_ = this.supportsConfigurationType(configurationType);
            ++buttonIndex;
        }
    }

    private void respawnNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().respawnNPC(this.getEasyNPCUUID());
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.confirmWarning", (Component)this.getEasyNPCEntity().m_5446_()), (Component)TextComponent.getTranslatedConfigText((String)"respawnNPC.respawnButton"), CommonComponents.f_130656_));
    }

    private void deleteNPC() {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed) {
                NetworkMessageHandlerManager.getServerHandler().removeNPC(this.getEasyNPCUUID());
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteQuestion"), (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteWarning", (Component)this.getEasyNPCEntity().m_5446_()), (Component)TextComponent.getTranslatedConfigText((String)"removeNPC.deleteButton"), CommonComponents.f_130656_));
    }

    private void validateName() {
        String nameValue = this.nameBox.m_94155_();
        int textColorValue = this.nameColorButton.getColorValue();
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        this.saveNameButton.f_93623_ = !this.formerName.equals(nameValue) || this.formerTextColor != textColorValue || this.formerNameVisibility != nameVisibility;
    }

    private void saveName() {
        String name = this.nameBox.m_94155_();
        int textColor = 0xFFFFFF;
        if (this.nameColorButton != null) {
            textColor = this.nameColorButton.getColorValue();
        }
        NameVisibilityType nameVisibility = this.nameVisibilityButton.getVisibilityType();
        NetworkMessageHandlerManager.getServerHandler().changeName(this.getEasyNPC().getEntityUUID(), name, textColor, nameVisibility);
        this.formerName = name;
        this.formerTextColor = textColor;
        this.formerNameVisibility = nameVisibility;
        this.saveNameButton.f_93623_ = false;
    }

    static {
        menuButtons.put("actions", ConfigurationType.BASIC_ACTION);
        menuButtons.put("attributes", ConfigurationType.ABILITIES_ATTRIBUTE);
        menuButtons.put("dialog", ConfigurationType.DIALOG);
        menuButtons.put("equipment", ConfigurationType.EQUIPMENT);
        menuButtons.put("objective", ConfigurationType.BASIC_OBJECTIVE);
        menuButtons.put("pose", ConfigurationType.POSE);
        menuButtons.put("position", ConfigurationType.DEFAULT_POSITION);
        menuButtons.put("rotation", ConfigurationType.DEFAULT_ROTATION);
        menuButtons.put("scaling", ConfigurationType.SCALING);
        menuButtons.put("trading", ConfigurationType.TRADING);
    }
}

