/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.ReloadButton;
import de.markusbordihn.easynpc.client.screen.components.SearchField;
import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.configui.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.screen.render.EntityScreenRenderer;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class CustomSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    private static final int ADD_SKIN_RELOAD_DELAY = 5;
    protected Button skinFolderButton = null;
    protected Button skinReloadButton = null;
    protected Checkbox disableLayersCheckbox = null;
    protected EditBox skinSearchField = null;
    private String searchFilter = null;

    public CustomSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.getEasyNPC() == null) {
            return;
        }
        int positionTop = 144;
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        Set textures = CustomTextureManager.getCustomTextureCacheKeys((SkinModel)skinModel, (String)this.searchFilter);
        this.numOfSkins = textures.size();
        Object[] textureKeys = textures.toArray();
        if (this.lastNumOfSkins != this.numOfSkins) {
            this.checkSkinNavigationButtonState();
            this.lastNumOfSkins = this.numOfSkins;
        }
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int left = this.leftPos + 32 + skinPosition * 60;
            int top = this.topPos + 65 + positionTop;
            UUID textureKey = (UUID)textureKeys[i];
            this.renderSkinEntity(guiGraphics, left, top, textureKey);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = TextUtils.normalizeString((String)textureKey.toString(), (int)11);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)variantName, (int)leftNamePos, (int)topNamePos, (int)43520);
            guiGraphics.m_280168_().m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(GuiGraphics guiGraphics, int x, int y, UUID textureUUID) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), SkinDataEntry.createCustomSkin((UUID)textureUUID, (this.disableLayersCheckbox != null && this.disableLayersCheckbox.selected() ? 1 : 0) != 0)));
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        UUID skinUUID = skinData.getSkinUUID();
        skinButton.f_93623_ = !skinUUID.equals(textureUUID);
        EntityScreenRenderer.renderEntity((GuiGraphics)guiGraphics, (EasyNPC)this.getEasyNPC(), (EntityRenderConfig)EntityRenderConfig.withOverrides((int)(x + 4), (int)y, (int)30, (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), (EntityRenderOverrides)EntityRenderOverrides.withSkin((SkinType)SkinType.CUSTOM, (UUID)textureUUID)));
        this.skinButtons.add(skinButton);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.customSkinButton.f_93623_ = false;
        this.setDescriptionText("custom_skin.text");
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        SkinModel skinModel = skinData.getSkinModel();
        this.numOfSkins = CustomTextureManager.getCustomTextureCacheKeys((SkinModel)skinModel).size();
        this.defineSkinNavigationButtons();
        Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder((SkinModel)skinModel);
        if (skinModelFolder != null) {
            this.skinFolderButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.contentLeftPos + 10, this.contentTopPos + 65, 263, "open_textures_folder", skinModel.toString(), onPress -> Util.m_137581_().m_137644_(skinModelFolder.toFile())));
        }
        this.skinReloadButton = (Button)this.m_142416_((GuiEventListener)new ReloadButton(this.skinFolderButton.m_252754_() + this.skinFolderButton.m_5711_(), this.skinFolderButton.m_252907_(), 17, 16, null, onPress -> {
            CustomSkinDataFiles.refreshRegisterTextureFiles();
            nextSkinReload = (int)Instant.now().getEpochSecond() + 5;
        }));
        this.skinSearchField = (EditBox)this.m_142416_((GuiEventListener)new SearchField(this.f_96547_, this.contentLeftPos + 100, this.contentTopPos + 190, 100, 14));
        this.skinSearchField.m_94151_(this::onSearchFieldChanged);
        this.disableLayersCheckbox = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.contentLeftPos + 55, this.contentTopPos + 85, "disable_skin_layers", skinData.getSkinDataEntry().disableLayers(), checkbox -> NetworkMessageHandlerManager.getServerHandler().setSkin(this.getEasyNPCUUID(), skinData.getSkinDataEntry().withDisableLayers(checkbox.selected()))));
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        if (this.skinReloadButton != null) {
            boolean canSkinReload;
            boolean bl = canSkinReload = Instant.now().getEpochSecond() >= (long)nextSkinReload;
            if (!canSkinReload) {
                Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"skin_reloading", (int)(this.contentLeftPos + 55), (int)(this.contentTopPos + 143), (int)0xFF5555);
            }
            this.skinReloadButton.f_93623_ = canSkinReload;
        }
        this.renderSkins(guiGraphics);
    }

    private void onSearchFieldChanged(String searchText) {
        if (searchText != null && !searchText.isEmpty()) {
            this.searchFilter = searchText;
            this.skinStartIndex = 0;
            this.checkSkinNavigationButtonState();
        } else {
            this.searchFilter = "";
        }
    }
}

