/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.trading;

import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.PositiveNumberField;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.screen.configuration.trading.TradingConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.utils.ValueUtils;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BasicTradingConfigurationContainerScreen<T extends ConfigurationMenu>
extends TradingConfigurationContainerScreen<T> {
    protected EditBox resetsEveryMinEditBox;
    protected EditBox maxUsesEditBox;
    protected EditBox rewardExpEditBox;

    public BasicTradingConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void onResetsEveryMinEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingResetsEveryMin(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onMaxUsesEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingMaxUses(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    private void onRewardExpEditBoxChanged(String text) {
        if (ValueUtils.isPositiveNumericValueOrZero((String)text) && !text.isEmpty()) {
            NetworkMessageHandlerManager.getServerHandler().setBasicTradingRewardExp(this.getEasyNPCUUID(), Integer.parseInt(text));
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.basicTradesButton.f_93623_ = false;
        TradingDataCapable tradingData = this.getEasyNPC().getEasyNPCTradingData();
        TradingDataSet tradingDataSet = tradingData.getTradingDataSet();
        this.resetsEveryMinEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 142, 32);
        this.resetsEveryMinEditBox.m_94199_(3);
        this.resetsEveryMinEditBox.m_94144_("" + tradingDataSet.getResetsEveryMin());
        this.resetsEveryMinEditBox.m_94151_(this::onResetsEveryMinEditBoxChanged);
        this.resetsEveryMinEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.resetsEveryMinEditBox);
        this.maxUsesEditBox = new PositiveNumberField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 165, 32);
        this.maxUsesEditBox.m_94199_(4);
        this.maxUsesEditBox.m_94144_("" + tradingDataSet.getMaxUses());
        this.maxUsesEditBox.m_94151_(this::onMaxUsesEditBoxChanged);
        this.maxUsesEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.maxUsesEditBox);
        this.rewardExpEditBox = new TextField(this.f_96547_, this.contentLeftPos + 166, this.contentTopPos + 188, 32);
        this.rewardExpEditBox.m_94199_(3);
        this.rewardExpEditBox.m_94144_("" + tradingDataSet.getRewardedXP());
        this.rewardExpEditBox.m_94151_(this::onRewardExpEditBoxChanged);
        this.rewardExpEditBox.m_94153_(ValueUtils::isPositiveNumericValueOrZero);
        this.m_142416_((GuiEventListener)this.rewardExpEditBox);
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.m_280072_(guiGraphics, x, y);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        int slotPositionX = this.f_97735_ + 30 - 1;
        int slotPositionY = this.f_97736_ + 40 - 1;
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            if (tradingOffer == 6) {
                slotPositionX = this.f_97735_ + 190 - 1;
                slotPositionY = this.f_97736_ + 40 - 1;
            }
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)((tradingOffer < 9 ? " " : "") + (tradingOffer + 1) + "."), (int)(slotPositionX - 15), (int)(slotPositionY + 5), (int)0x404040);
            int itemASlotLeftPosition = slotPositionX;
            int itemASlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)itemASlotLeftPosition, (int)itemASlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"+", (int)(itemASlotLeftPosition + 18 + 6), (int)(itemASlotTopPosition + 5), (int)0x404040);
            int itemBSlotLeftPosition = slotPositionX + 18 + 18;
            int itemBSlotTopPosition = slotPositionY;
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)itemBSlotLeftPosition, (int)itemBSlotTopPosition, (int)7, (int)7, (int)18, (int)18);
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"=", (int)(itemBSlotLeftPosition + 18 + 12), (int)(itemBSlotTopPosition + 5), (int)0x404040);
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(slotPositionX + 82), (int)slotPositionY, (int)7, (int)7, (int)18, (int)18);
            slotPositionY += 19;
        }
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)this.contentLeftPos, (int)(this.contentTopPos + 135), (int)7, (int)83, (int)162, (int)54);
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)this.contentLeftPos, (int)(this.contentTopPos + 191), (int)7, (int)141, (int)162, (int)18);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"trading.minutes_for_trade_reset", (int)(this.contentLeftPos + 202), (int)(this.resetsEveryMinEditBox.m_252907_() + 3), (int)0x404040);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"trading.max_uses_per_trade", (int)(this.contentLeftPos + 202), (int)(this.maxUsesEditBox.m_252907_() + 3), (int)0x404040);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)"trading.rewarded_exp_per_trade", (int)(this.contentLeftPos + 202), (int)(this.rewardExpEditBox.m_252907_() + 3), (int)0x404040);
    }
}

