/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.editor.action;

import de.markusbordihn.easynpc.client.screen.components.DeleteButton;
import de.markusbordihn.easynpc.client.screen.components.EditButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.UpDownButton;
import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;

public class ActionDataListEntry
extends ObjectSelectionList.Entry<ActionDataListEntry> {
    public static final int ID_LEFT_POS = 0;
    public static final int TYPE_LEFT_POS = 22;
    public static final int VALUE_LEFT_POS = 130;
    public static final int OPTIONS_LEFT_POS = 230;
    private final Font font;
    private final int leftPos;
    private final int topPos;
    private final int entryHeight = 21;
    private final ActionDataEntry actionDataEntry;
    private final ActionDataType actionDataType;
    private final int actionDateEntriesSize;
    private final EditButton editButton;
    private final DeleteButton deleteButton;
    private final UpDownButton upAndDownButton;

    public ActionDataListEntry(Minecraft minecraft, ActionDataEntry actionDataEntry, ActionDataSet actionDataSet, int leftPos, int topPos, OnUp onUp, OnDown onDown, OnEdit onEdit, OnRemove onRemove) {
        this.font = minecraft.f_91062_;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.actionDataEntry = actionDataEntry;
        this.actionDataType = actionDataEntry != null ? actionDataEntry.actionDataType() : ActionDataType.NONE;
        this.actionDateEntriesSize = actionDataSet != null ? actionDataSet.getEntries().size() : 1;
        this.upAndDownButton = new UpDownButton(this.leftPos + 230 + 4, this.topPos, 18, 18, onPress -> {
            if (onUp != null) {
                onUp.changeOrder(actionDataEntry);
            }
        }, onPress -> {
            if (onDown != null) {
                onDown.changeOrder(actionDataEntry);
            }
        });
        this.editButton = new EditButton(this.upAndDownButton.m_252754_() + this.upAndDownButton.m_5711_() + 2, this.topPos, 18, 18, onPress -> {
            if (onEdit != null) {
                onEdit.edit(actionDataEntry);
            }
        });
        this.deleteButton = new DeleteButton(this.editButton.m_252754_() + this.editButton.m_5711_() + 2, this.topPos, onPress -> {
            if (onRemove != null) {
                onRemove.remove(actionDataEntry);
            }
        });
    }

    public Component m_142172_() {
        return TextComponent.getText((String)(this.actionDataType.name() + ":" + this.actionDataEntry.command()));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        this.upAndDownButton.m_6375_(mouseX, mouseY, button);
        this.editButton.m_6375_(mouseX, mouseY, button);
        this.deleteButton.m_6375_(mouseX, mouseY, button);
        return button == 0;
    }

    public void m_6311_(GuiGraphics guiGraphics, int entryId, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        guiGraphics.m_280509_(this.leftPos, top + entryHeight + 2, this.leftPos + 309, top + entryHeight + 3, -5592406);
        int fieldsLeft = this.leftPos + 5;
        Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)String.valueOf(entryId), (int)(fieldsLeft + 0 + 2), (int)(top + 5), (int)0);
        Text.drawConfigString((GuiGraphics)guiGraphics, (Font)this.font, (String)this.actionDataType.getId(), (int)(fieldsLeft + 22 + 2), (int)(top + 5), (int)0);
        if (this.actionDataType == ActionDataType.COMMAND || this.actionDataType == ActionDataType.OPEN_NAMED_DIALOG) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.limitString((String)this.actionDataEntry.command(), (int)16), (int)(fieldsLeft + 130 + 2), (int)(top + 5), (int)0);
        } else if (this.actionDataType == ActionDataType.INTERACT_BLOCK) {
            Text.drawString((GuiGraphics)guiGraphics, (Font)this.font, (String)TextUtils.limitString((String)this.actionDataEntry.blockPos().toString(), (int)16), (int)(fieldsLeft + 130 + 2), (int)(top + 5), (int)0);
        }
        this.upAndDownButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.upAndDownButton.m_253211_(top);
        this.upAndDownButton.enableUpButton(entryId > 0);
        this.upAndDownButton.enableDownButton(entryId < this.actionDateEntriesSize - 1);
        this.editButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.editButton.m_253211_(top);
        this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.deleteButton.m_253211_(top);
        this.renderSeparatorLines(guiGraphics, top);
    }

    public void renderSeparatorLines(GuiGraphics guiGraphics, int top) {
        int separatorTop = top - 1;
        int separatorLeft = this.leftPos + 5;
        guiGraphics.m_280509_(separatorLeft + 22 - 3, separatorTop, separatorLeft + 22 - 2, separatorTop + 21, -10066330);
        guiGraphics.m_280509_(separatorLeft + 130 - 3, separatorTop, separatorLeft + 130 - 2, separatorTop + 21, -10066330);
        guiGraphics.m_280509_(separatorLeft + 230 - 3, separatorTop, separatorLeft + 230 - 2, separatorTop + 21, -10066330);
    }

    public static interface OnUp {
        public void changeOrder(ActionDataEntry var1);
    }

    public static interface OnDown {
        public void changeOrder(ActionDataEntry var1);
    }

    public static interface OnEdit {
        public void edit(ActionDataEntry var1);
    }

    public static interface OnRemove {
        public void remove(ActionDataEntry var1);
    }
}

