/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangeModelPoseMessage(UUID uuid, ModelPose modelPose) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_model_pose");

    public static ChangeModelPoseMessage create(FriendlyByteBuf buffer) {
        return new ChangeModelPoseMessage(buffer.m_130259_(), (ModelPose)buffer.m_130066_(ModelPose.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.modelPose);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.modelPose == null) {
            log.error("Invalid model pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Invalid model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change modelPose {} for {} from {}", (Object)this.modelPose, (Object)easyNPC, (Object)serverPlayer);
        modelData.setModelPose(this.modelPose);
        easyNPC.getEntity().m_20124_(Pose.STANDING);
    }
}

