/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.preset;

import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationScreen;
import de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class ImportPresetConfigurationScreen<T extends ConfigurationMenu>
extends ConfigurationScreen<T> {
    protected static ResourceLocation selectedPreset;
    protected static List<ResourceLocation> presetList;
    protected Button localImportPresetButton;
    protected Button customImportPresetButton;
    protected Button defaultImportPresetButton;
    protected Button worldImportPresetButton;
    protected String importPresetButtonLabel = "import_preset";
    protected String importPresetHeaderLabel = "import_preset_header";
    protected Button importPresetButton;
    ImportFileSelectionList presetSelectionList;

    public ImportPresetConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static void updateSelectedPreset(ResourceLocation resourceLocation) {
        selectedPreset = resourceLocation;
    }

    public static void updatePresets(List<ResourceLocation> presets) {
        presetList = presets;
    }

    public static List<ResourceLocation> getPresets() {
        return presetList;
    }

    public static boolean hasNoPresets() {
        return presetList == null || presetList.isEmpty();
    }

    public void loadPresetConfirm(ResourceLocation resourceLocation) {
        Minecraft minecraft = this.f_96541_;
        if (minecraft == null) {
            return;
        }
        minecraft.m_91152_((Screen)new ConfirmScreen(confirmed -> {
            if (confirmed && this.getEasyNPCUUID() != null) {
                this.loadPreset(resourceLocation);
                minecraft.m_91152_(null);
            } else {
                minecraft.m_91152_((Screen)this);
            }
        }, (Component)TextComponent.getTranslatedConfigText((String)"preset.importQuestion", (String)resourceLocation.m_135815_().substring(resourceLocation.m_135815_().lastIndexOf("/") + 1)), (Component)TextComponent.getTranslatedConfigText((String)"preset.importWarning", (String)this.getEasyNPCEntity().m_5446_().getString()), (Component)TextComponent.getTranslatedConfigText((String)"preset.importButton"), CommonComponents.f_130656_));
    }

    public void loadPreset(ResourceLocation resourceLocation) {
        log.error("Not implemented! Received resource location {}", (Object)resourceLocation);
    }

    public String getPresetFileName(ResourceLocation resourceLocation) {
        this.getSkinModel();
        return resourceLocation.m_135815_().replace("preset/" + this.getSkinModel().toString().toLowerCase(Locale.ROOT) + "/", "").replace(".npc.nbt", "");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int buttonWidth = 70;
        this.localImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth - 4, "local", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.LOCAL_PRESET_IMPORT)));
        this.defaultImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.localImportPresetButton.m_252754_() + this.localImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth - 4, "default", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.DEFAULT_PRESET_IMPORT)));
        this.worldImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.defaultImportPresetButton.m_252754_() + this.defaultImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth - 6, "world_preset", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.WORLD_PRESET_IMPORT)));
        this.customImportPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.worldImportPresetButton.m_252754_() + this.worldImportPresetButton.m_5711_(), this.buttonTopPos, buttonWidth + 15, "custom", button -> NetworkMessageHandlerManager.getServerHandler().openConfiguration(this.getEasyNPCUUID(), ConfigurationType.CUSTOM_PRESET_IMPORT)));
        this.importPresetButton = (Button)this.m_142416_((GuiEventListener)new TextButton(this.buttonLeftPos + 25, this.bottomPos - 40, 220, this.importPresetButtonLabel, button -> {
            if (selectedPreset != null) {
                this.loadPresetConfirm(selectedPreset);
            }
        }));
        this.presetSelectionList = new ImportFileSelectionList(this.f_96541_);
        this.m_7787_((GuiEventListener)this.presetSelectionList);
        ImportPresetConfigurationScreen.updateSelectedPreset(null);
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        if (this.presetSelectionList != null) {
            this.presetSelectionList.m_88315_(guiGraphics, x, y, partialTicks);
        }
        if (this.importPresetButton != null) {
            this.importPresetButton.f_93623_ = selectedPreset != null;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int fileListTop = this.topPos + 55;
        int fileListHeight = fileListTop + 110;
        int fileListWidth = this.leftPos + 290;
        guiGraphics.m_280509_(this.contentLeftPos - 1, fileListTop - 1, fileListWidth + 1, fileListHeight + 1, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos, fileListTop, fileListWidth, fileListHeight, -5592406);
    }

    class ImportFileSelectionList
    extends ObjectSelectionList<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
        public ImportFileSelectionList(Minecraft minecraft) {
            super(minecraft, ImportPresetConfigurationScreen.this.f_96543_ - 5, ImportPresetConfigurationScreen.this.f_96544_ - 150 + 66, ImportPresetConfigurationScreen.this.topPos + 66, ImportPresetConfigurationScreen.this.f_96544_ - 150 - ImportPresetConfigurationScreen.this.topPos + 66, 14);
            this.m_93473_(false, 0);
            this.m_93488_(false);
            this.m_93496_(false);
            this.updatePresets();
        }

        public void updatePresets() {
            this.m_93516_();
            if (ImportPresetConfigurationScreen.hasNoPresets()) {
                return;
            }
            ImportPresetConfigurationScreen.getPresets().forEach(resourceLocation -> {
                Entry entry = new Entry((ResourceLocation)resourceLocation, ImportPresetConfigurationScreen.this.getSkinModel());
                this.m_7085_((AbstractSelectionList.Entry)entry);
            });
        }

        protected int m_5756_() {
            return super.m_5756_() + 12;
        }

        public int m_5759_() {
            return super.m_5759_() + 40;
        }

        public boolean m_93696_() {
            return ImportPresetConfigurationScreen.this.m_7222_() == this;
        }

        public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
            if (this.m_5773_() > 0) {
                super.m_88315_(guiGraphics, x, y, partialTicks);
                return;
            }
            Text.drawConfigStringShadow((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.f_96547_, (String)"no_presets_found", (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 80), (int)(ImportPresetConfigurationScreen.this.topPos + 105), (int)0xFFFFFF);
        }

        public class Entry
        extends ObjectSelectionList.Entry<de.markusbordihn.easynpc.configui.client.screen.configuration.preset.ImportPresetConfigurationScreen$ImportFileSelectionList.Entry> {
            final ResourceLocation resourceLocation;
            final SkinModel skinModel;
            final String fileName;

            public Entry(ResourceLocation resourceLocation, SkinModel skinModel) {
                this.resourceLocation = resourceLocation;
                this.skinModel = skinModel;
                this.fileName = ImportPresetConfigurationScreen.this.getPresetFileName(resourceLocation);
            }

            public void m_6311_(GuiGraphics guiGraphics, int x, int y, int unused1, int unused2, int unused3, int unused4, int unused5, boolean unused6, float partialTicks) {
                int fileListTop = ImportPresetConfigurationScreen.this.topPos + 55;
                int fileListWidth = ImportPresetConfigurationScreen.this.leftPos + 290;
                guiGraphics.m_280509_(ImportPresetConfigurationScreen.this.contentLeftPos - 1, fileListTop - 4, fileListWidth + 1, fileListTop + 12, -16777216);
                guiGraphics.m_280509_(ImportPresetConfigurationScreen.this.contentLeftPos, fileListTop - 3, fileListWidth, fileListTop + 11, -7829368);
                Text.drawConfigStringShadowWithData((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.f_96547_, (String)ImportPresetConfigurationScreen.this.importPresetHeaderLabel, (String)this.skinModel.getName(), (int)(ImportPresetConfigurationScreen.this.contentLeftPos + 3), (int)fileListTop, (int)0xFFFFFF);
                Text.drawStringShadow((GuiGraphics)guiGraphics, (Font)ImportPresetConfigurationScreen.this.f_96547_, (String)this.fileName, (int)(ImportFileSelectionList.this.f_93388_ / 2 - ImportPresetConfigurationScreen.this.f_96547_.m_92895_(this.fileName) / 2), (int)(y + 1), (int)0xFFFFFF);
            }

            public boolean m_6375_(double unused1, double unused2, int button) {
                if (button == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                ImportFileSelectionList.this.m_6987_((AbstractSelectionList.Entry)this);
                log.debug("Selected file {}.", (Object)this.resourceLocation);
                ImportPresetConfigurationScreen.updateSelectedPreset(this.resourceLocation);
            }

            public Component m_142172_() {
                return TextComponent.getText((String)this.resourceLocation.m_135815_());
            }
        }
    }
}

