/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.configuration;

import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.AdvancedTradingConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.trading.BasicTradingConfigurationMenu;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;

public class ConfigurationMenuHandler {
    public static MenuProvider getMenuProvider(final ConfigurationType configurationType, EasyNPC<?> easyNPC, final MenuType<? extends ConfigurationMenu> menuType, final ScreenData screenData) {
        final Component displayName = ConfigurationMenuHandler.getConfigurationTitle(configurationType, easyNPC);
        if (configurationType == ConfigurationType.EQUIPMENT) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new EquipmentConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }

                public String toString() {
                    return "EquipmentConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        if (configurationType == ConfigurationType.ADVANCED_TRADING) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new AdvancedTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }

                public String toString() {
                    return "AdvancedTradingConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        if (configurationType == ConfigurationType.BASIC_TRADING) {
            return new MenuProvider(){

                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    return new BasicTradingConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
                }

                public Component m_5446_() {
                    return displayName;
                }

                public String toString() {
                    return "BasicTradingConfigurationMenu[" + String.valueOf(displayName) + "]";
                }
            };
        }
        return new MenuProvider(){

            public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                return new ConfigurationMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public Component m_5446_() {
                return displayName;
            }

            public String toString() {
                return "ConfigurationMenu." + String.valueOf(configurationType) + "[" + String.valueOf(displayName) + "]";
            }
        };
    }

    public static ScreenData getScreenData(ConfigurationType configurationType, EasyNPC<?> easyNPC, ServerPlayer serverPlayer, int pageIndex) {
        UUID npcUUID = easyNPC.getEntityUUID();
        CompoundTag additionalSyncData = new CompoundTag();
        switch (configurationType) {
            case DEFAULT_PRESET_IMPORT: {
                Set defaultPresets = DefaultPresetDataFiles.getPresetResourceLocations((MinecraftServer)serverPlayer.m_20194_()).collect(Collectors.toSet());
                additionalSyncData.m_128365_("DefaultPresets", (Tag)CompoundTagUtils.writeResourceLocations(defaultPresets));
                break;
            }
            case CUSTOM_PRESET_IMPORT: {
                CustomPresetDataFiles.refreshPresetResourceLocations();
                Set customPresets = CustomPresetDataFiles.getPresetResourceLocationSet();
                additionalSyncData.m_128365_("CustomPresets", (Tag)CompoundTagUtils.writeResourceLocations((Set)customPresets));
                break;
            }
            case WORLD_PRESET_IMPORT: {
                WorldPresetDataFiles.refreshPresetResourceLocations();
                Set worldPresets = WorldPresetDataFiles.getPresetResourceLocationSet();
                additionalSyncData.m_128365_("WorldPresets", (Tag)CompoundTagUtils.writeResourceLocations((Set)worldPresets));
                break;
            }
            case BASIC_ACTION: 
            case DIALOG_ACTION: 
            case DISTANCE_ACTION: {
                AdditionalScreenData.addActionEventSet((CompoundTag)additionalSyncData, easyNPC);
                break;
            }
            case BASE_ATTRIBUTE: {
                AdditionalScreenData.addBaseAttributes((CompoundTag)additionalSyncData, easyNPC);
                break;
            }
            case NONE_DIALOG: 
            case BASIC_DIALOG: 
            case YES_NO_DIALOG: 
            case ADVANCED_DIALOG: {
                AdditionalScreenData.addDialogDataSet((CompoundTag)additionalSyncData, easyNPC);
                break;
            }
            case ATTACK_OBJECTIVE: 
            case BASIC_OBJECTIVE: 
            case FOLLOW_OBJECTIVE: 
            case LOOK_OBJECTIVE: {
                AdditionalScreenData.addObjectiveDataSet((CompoundTag)additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, null, null, null, pageIndex, additionalSyncData);
    }

    private static Component getConfigurationTitle(ConfigurationType configurationType, EasyNPC<?> easyNPC) {
        return TextComponent.getTranslatedConfigText((String)(configurationType.name().toLowerCase(Locale.ROOT) + ".title"), (String)easyNPC.getEntity().m_7755_().m_130668_(16));
    }
}

