/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message;

import de.markusbordihn.easynpc.configui.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.configui.network.message.client.ExportClientPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ClientNetworkMessageHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    default public void openMenu(UUID uuid, UUID menuId, ServerPlayer serverPlayer, CompoundTag data) {
        if (uuid != null && menuId != null && serverPlayer != null) {
            log.debug("Send menu callback {} for npc {} and player {} with: {}", (Object)menuId, (Object)uuid, (Object)serverPlayer, (Object)data);
            NetworkHandlerManager.sendMessageToPlayer(new OpenMenuCallbackMessage(uuid, menuId, data), serverPlayer);
        }
    }

    default public void exportClientPreset(UUID uuid, String name, ServerPlayer serverPlayer) {
        if (name == null || name.isEmpty() || !NetworkMessageRecord.checkAccess((UUID)uuid, (ServerPlayer)serverPlayer)) {
            return;
        }
        EasyNPC easyNPC = LivingEntityManager.getEasyNPCEntityByUUID((UUID)uuid, (ServerPlayer)serverPlayer);
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        CompoundTag compoundTag = presetData.serializePresetData();
        log.info("Exporting preset for {} to {}", (Object)easyNPC.getEntity().m_7755_().getString(), (Object)serverPlayer.m_7755_().getString());
        NetworkHandlerManager.sendMessageToPlayer(new ExportClientPresetMessage(uuid, easyNPC.getEntity().m_7755_().getString(), easyNPC.getEasyNPCSkinData().getSkinModel(), name, compoundTag), serverPlayer);
    }
}

