/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public record ChangePositionMessage(UUID uuid, Vec3 pos) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "change_position");

    public static ChangePositionMessage create(FriendlyByteBuf buffer) {
        return new ChangePositionMessage(buffer.m_130259_(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.writeDouble(this.pos.f_82479_);
        buffer.writeDouble(this.pos.f_82480_);
        buffer.writeDouble(this.pos.f_82481_);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.pos == null) {
            log.error("Invalid pos for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change pos {} for {} from {}", (Object)this.pos, (Object)easyNPC, (Object)serverPlayer);
        easyNPC.getEntity().m_146884_(this.pos);
    }
}

