/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record OpenConfigurationMessage(UUID uuid, ConfigurationType configurationType, int pageIndex) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = new ResourceLocation("easy_npc_config_ui", "open_configuration_screen");

    public static OpenConfigurationMessage create(FriendlyByteBuf buffer) {
        return new OpenConfigurationMessage(buffer.m_130259_(), (ConfigurationType)buffer.m_130066_(ConfigurationType.class), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.uuid);
        buffer.m_130068_((Enum)this.configurationType);
        buffer.writeInt(this.pageIndex);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.configurationType == null) {
            log.error("Invalid configuration type for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.pageIndex < 0) {
            log.error("Invalid page index {} for {} from {}", (Object)this.pageIndex, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        MenuManager.getMenuHandler().openConfigurationMenu(this.configurationType, serverPlayer, easyNPC, this.pageIndex);
    }
}

