/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.data.dialog.DialogDataEntry;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record OpenDialogEditorMessage(UUID uuid, UUID dialogId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"open_dialog_editor");
    public static final class_8710.class_9154<OpenDialogEditorMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, OpenDialogEditorMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), OpenDialogEditorMessage::create);

    public static OpenDialogEditorMessage create(class_2540 buffer) {
        return new OpenDialogEditorMessage(buffer.method_10790(), buffer.method_10790());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Unable to get valid dialog data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        UUID newDialogId = this.dialogId;
        if (this.dialogId.equals(EMPTY_UUID)) {
            String dialogName = dialogData.getDialogDataSet().hasDialog() ? "Dialog " + RANDOM.nextInt(1000) : "Default";
            DialogDataEntry newDialogData = new DialogDataEntry(dialogName);
            log.info("Create new dialog {} for {} from {}", (Object)newDialogData, (Object)easyNPC, (Object)serverPlayer);
            dialogData.getDialogDataSet().addDialog(newDialogData);
            newDialogId = newDialogData.getId();
        } else if (!dialogData.hasDialog(this.dialogId)) {
            log.error("Unknown dialog button editor request for dialog {} for {} from {}", (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            log.debug("Available dialogs for {} are {}", (Object)easyNPC, (Object)dialogData.getDialogDataSet());
            return;
        }
        log.info("Open dialog editor with for dialog {} for {} from {}", (Object)newDialogId, (Object)easyNPC, (Object)serverPlayer);
        MenuManager.getMenuHandler().openEditorMenu(EditorType.DIALOG, serverPlayer, easyNPC, newDialogId, 0);
    }
}

