/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.skin;

import de.markusbordihn.easynpc.client.screen.components.SkinSelectionButton;
import de.markusbordihn.easynpc.client.screen.components.Text;
import de.markusbordihn.easynpc.configui.client.screen.configuration.skin.SkinConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import de.markusbordihn.easynpc.screen.ScreenHelper;
import de.markusbordihn.easynpc.utils.TextUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;

public class DefaultSkinConfigurationScreen<T extends ConfigurationMenu>
extends SkinConfigurationScreen<T> {
    private static final float SKIN_NAME_SCALING = 0.7f;
    protected int numOfProfessions = 0;
    protected int numOfVariants = 0;

    public DefaultSkinConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
        this.maxSkinsPerPage = 10;
    }

    private void renderSkins(GuiGraphics guiGraphics) {
        if (this.getEasyNPCEntity() == null) {
            return;
        }
        int skinPosition = 0;
        this.skinButtons = new ArrayList();
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        for (int i = this.skinStartIndex; i < this.numOfSkins && i < this.skinStartIndex + this.maxSkinsPerPage; ++i) {
            int variantIndex = i;
            if (variantIndex >= variantData.getVariantTypes().length) {
                variantIndex %= variantData.getVariantTypes().length;
            }
            Enum variant = variantData.getVariantTypes()[variantIndex];
            int left = this.leftPos + (skinPosition > 4 ? -268 : 32) + skinPosition * 60;
            int top = this.contentTopPos + 102 + (skinPosition > 4 ? 84 : 0);
            this.renderSkinEntity(left, top, variant, null);
            int topNamePos = Math.round(((float)top - 76.0f) / 0.7f);
            int leftNamePos = Math.round(((float)left - 21.0f) / 0.7f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 0.7f);
            String variantName = variant.name();
            if (this.getEasyNPCEntity() instanceof Villager && variantName.contains("_") && !variantName.equals("DEFAULT")) {
                String[] parts = variantName.split("_", 2);
                Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)TextUtils.normalizeString((String)parts[0], (int)14), (int)leftNamePos, (int)topNamePos, (int)43520);
                Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)TextUtils.normalizeString((String)parts[1], (int)13), (int)leftNamePos, (int)(topNamePos + 10), (int)0);
            } else {
                Text.drawString((GuiGraphics)guiGraphics, (Font)this.f_96547_, (String)TextUtils.normalizeString((String)variantName, (int)14), (int)leftNamePos, (int)topNamePos, (int)43520);
            }
            guiGraphics.m_280168_().m_85849_();
            ++skinPosition;
        }
    }

    private void renderSkinEntity(int x, int y, Enum<?> variantType, Profession profession) {
        SkinSelectionButton skinButton = new SkinSelectionButton(x - 24, y - 81, button -> {
            if (profession != null) {
                NetworkMessageHandlerManager.getServerHandler().changeProfession(this.getEasyNPCUUID(), profession);
            }
            NetworkMessageHandlerManager.getServerHandler().setDefaultSkin(this.getEasyNPCUUID(), variantType);
        });
        SkinDataCapable skinData = this.getEasyNPC().getEasyNPCSkinData();
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionDataCapable professionData = this.getEasyNPC().getEasyNPCProfessionData();
        skinButton.f_93623_ = skinData.getSkinType() != SkinType.DEFAULT || !variantData.getVariantType().equals(variantType) || profession != null && !professionData.getProfession().equals((Object)profession);
        ScreenHelper.renderEntityDefaultSkin((int)(x + 4), (int)y, (float)((float)x - this.xMouse), (float)((float)(y - 40) - this.yMouse), (EasyNPC)this.getEasyNPC(), variantType, (Profession)profession);
        this.skinButtons.add(skinButton);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.defaultSkinButton.f_93623_ = false;
        this.setDescriptionText("default_skin.text");
        VariantDataCapable variantData = this.getEasyNPC().getEasyNPCVariantData();
        ProfessionDataCapable professionData = this.getEasyNPC().getEasyNPCProfessionData();
        this.numOfProfessions = professionData.hasProfessions() ? professionData.getProfessions().length : 0;
        this.numOfSkins = this.numOfVariants = variantData.getVariantTypes().length;
        log.debug("Found {} predefined variant combinations.", (Object)this.numOfSkins);
        this.defineSkinNavigationButtons();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderDescriptionText(guiGraphics, this.contentLeftPos + 5, this.contentTopPos + 5);
        this.renderSkins(guiGraphics);
    }

    @Override
    protected void renderSkinSelectionBackground(GuiGraphics guiGraphics) {
        guiGraphics.m_280509_(this.contentLeftPos, this.contentTopPos + 20, this.contentLeftPos + 302, this.contentTopPos + 190, -16777216);
        guiGraphics.m_280509_(this.contentLeftPos + 1, this.contentTopPos + 21, this.contentLeftPos + 301, this.contentTopPos + 189, -5592406);
    }
}

