/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.components;

import de.markusbordihn.easynpc.client.screen.components.MultiStateToggleButton;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.class_2561;

public class NameVisibilityToggleButton
extends MultiStateToggleButton {
    public static final int SPRITE_OFFSET_Y_NEVER = 166;
    public static final int SPRITE_OFFSET_Y_ALWAYS = 154;
    public static final int SPRITE_OFFSET_Y_NEAR = 178;
    public static final int SPRITE_OFFSET_X = 92;
    private NameVisibilityType currentVisibilityType;

    public NameVisibilityToggleButton(int left, int top, NameVisibilityType initialType, OnVisibilityChange onVisibilityChange) {
        this(left, top, 18, 18, initialType, onVisibilityChange);
    }

    public NameVisibilityToggleButton(int left, int top, int width, int height, NameVisibilityType initialType, OnVisibilityChange onVisibilityChange) {
        super(left, top, width, height, NameVisibilityToggleButton.createVisibilityStates(), NameVisibilityToggleButton.getStateIndexFromType(initialType), (button, newStateIndex) -> {
            NameVisibilityToggleButton nameButton = (NameVisibilityToggleButton)button;
            nameButton.currentVisibilityType = NameVisibilityToggleButton.getTypeFromStateIndex(newStateIndex);
            if (onVisibilityChange != null) {
                onVisibilityChange.onVisibilityChange(nameButton, nameButton.currentVisibilityType);
            }
        });
        this.currentVisibilityType = initialType;
    }

    private static MultiStateToggleButton.ToggleState[] createVisibilityStates() {
        return new MultiStateToggleButton.ToggleState[]{new MultiStateToggleButton.ToggleState(92, 166, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.never")), new MultiStateToggleButton.ToggleState(92, 154, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.always")), new MultiStateToggleButton.ToggleState(92, 178, (class_2561)TextComponent.getTranslatedConfigText((String)"name_visibility.near"))};
    }

    private static int getStateIndexFromType(NameVisibilityType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case NameVisibilityType.NEVER -> 0;
            case NameVisibilityType.ALWAYS -> 1;
            case NameVisibilityType.NEAR -> 2;
        };
    }

    private static NameVisibilityType getTypeFromStateIndex(int stateIndex) {
        return switch (stateIndex) {
            case 0 -> NameVisibilityType.NEVER;
            case 1 -> NameVisibilityType.ALWAYS;
            case 2 -> NameVisibilityType.NEAR;
            default -> NameVisibilityType.ALWAYS;
        };
    }

    public NameVisibilityType getVisibilityType() {
        return this.currentVisibilityType;
    }

    public void setVisibilityType(NameVisibilityType type) {
        this.currentVisibilityType = type;
        this.setCurrentStateIndex(NameVisibilityToggleButton.getStateIndexFromType(type));
    }

    @FunctionalInterface
    public static interface OnVisibilityChange {
        public void onVisibilityChange(NameVisibilityToggleButton var1, NameVisibilityType var2);
    }
}

