/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.AttributeHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;

public record ChangeEntityBaseAttributeMessage(UUID uuid, Attribute attribute, Double value) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_entity_base_attribute");
    public static final CustomPacketPayload.Type<ChangeEntityBaseAttributeMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeEntityBaseAttributeMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeEntityBaseAttributeMessage::create);

    public static ChangeEntityBaseAttributeMessage create(FriendlyByteBuf buffer) {
        return new ChangeEntityBaseAttributeMessage(buffer.readUUID(), (Attribute)BuiltInRegistries.ATTRIBUTE.getValue(buffer.readResourceLocation()), buffer.readDouble());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeResourceLocation(BuiltInRegistries.ATTRIBUTE.getKey((Object)this.attribute));
        buffer.writeDouble(this.value.doubleValue());
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.attribute == null) {
            log.error("Invalid base attribute for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.value == null) {
            log.error("Invalid value for base attribute {} for {} from {}", (Object)this.attribute, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!AttributeHandler.setBaseAttribute((EasyNPC)easyNPC, (Attribute)this.attribute, (Double)this.value)) {
            log.error("Unable to set base attribute {} for {} from {}", (Object)this.attribute, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

