/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;

public record ChangePoseMessage(UUID uuid, Pose pose) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_pose");
    public static final CustomPacketPayload.Type<ChangePoseMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangePoseMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangePoseMessage::create);

    public static ChangePoseMessage create(FriendlyByteBuf buffer) {
        return new ChangePoseMessage(buffer.readUUID(), (Pose)buffer.readEnum(Pose.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.pose);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.pose == null) {
            log.error("Invalid pose for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            log.error("Missing model data for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        log.debug("Change pose {} for {} from {}", (Object)this.pose, (Object)easyNPC, (Object)serverPlayer);
        modelData.setModelPose(ModelPose.DEFAULT);
        easyNPC.getEntity().setPose(this.pose);
    }
}

