/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.trading.TradingValueType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import de.markusbordihn.easynpc.handler.TradingOfferHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeBasicTradingMessage(UUID uuid, TradingValueType tradingValueType, int tradingValue) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_basic_trading");
    public static final CustomPacketPayload.Type<ChangeBasicTradingMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeBasicTradingMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeBasicTradingMessage::create);

    public static ChangeBasicTradingMessage create(FriendlyByteBuf buffer) {
        return new ChangeBasicTradingMessage(buffer.readUUID(), (TradingValueType)buffer.readEnum(TradingValueType.class), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeEnum((Enum)this.tradingValueType);
        buffer.writeInt(this.tradingValue);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.tradingValueType == null) {
            log.error("Trading value type is unknown for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.tradingValue < 0) {
            log.error("Trading value {} for {} is out of range (>= 0) for {}", (Object)this.tradingValue, (Object)this.tradingValueType, (Object)serverPlayer);
            return;
        }
        TradingDataCapable tradingData = easyNPC.getEasyNPCTradingData();
        if (tradingData == null) {
            log.error("Trading data for {} is not available for {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.tradingValueType) {
            case RESET_TRADING_EVERY_MIN: {
                log.debug("Set trading resets every min to {} for {} from {}", (Object)this.tradingValue, (Object)easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setResetsEveryMin(this.tradingValue);
                break;
            }
            case MAX_USES: {
                log.debug("Set max uses to {} for {} from {}", (Object)this.tradingValue, (Object)easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setMaxUses(this.tradingValue);
                TradingOfferHandler.updateBasicTradingOffers((TradingDataCapable)tradingData);
                break;
            }
            case REWARD_EXP: {
                log.debug("Set reward exp to {} for {} from {}", (Object)this.tradingValue, (Object)easyNPC, (Object)serverPlayer);
                tradingData.getTradingDataSet().setRewardedXP(this.tradingValue);
                TradingOfferHandler.updateBasicTradingOffers((TradingDataCapable)tradingData);
                break;
            }
            default: {
                log.error("Trading value type {} is unknown for {}", (Object)this.tradingValueType, (Object)serverPlayer);
            }
        }
    }
}

