/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.PresetDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public record ExportWorldPresetMessage(UUID uuid, String name) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "export_world_preset");

    public static ExportWorldPresetMessage create(class_2540 buffer) {
        return new ExportWorldPresetMessage(buffer.method_10790(), buffer.method_19772());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.name);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.name == null || this.name.isEmpty()) {
            log.warn("Export preset name is empty for {}", (Object)easyNPC);
            return;
        }
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData == null) {
            log.warn("Export preset skin data is empty for {}", (Object)easyNPC);
            return;
        }
        SkinModel skinModel = skinData.getSkinModel();
        if (skinModel == null) {
            log.warn("Export preset skin model is empty for {}", (Object)easyNPC);
            return;
        }
        PresetDataCapable presetData = easyNPC.getEasyNPCPresetData();
        class_2487 compoundTag = presetData.serializePresetData();
        if (compoundTag == null || compoundTag.method_33133()) {
            log.warn("Export preset data is empty for {}", (Object)easyNPC);
            return;
        }
        File presetFile = WorldPresetDataFiles.getPresetFile((SkinModel)skinModel, (String)this.name);
        if (presetFile == null) {
            log.error("Failed to get preset file for {} with name {}", (Object)skinModel, (Object)this.name);
            return;
        }
        log.info("Exporting EasyNPC {} with {} and skin {} to {}", (Object)this.name, (Object)easyNPC, (Object)skinModel, (Object)presetFile);
        try {
            class_2507.method_30614((class_2487)compoundTag, (File)presetFile);
        }
        catch (IOException exception) {
            log.error("Failed to export EasyNPC {} with {} and skin {} to {}:", (Object)this.name, (Object)easyNPC, (Object)skinModel, (Object)presetFile, (Object)exception);
        }
    }
}

