/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.editor;

import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3908;
import net.minecraft.class_3917;

public class EditorMenuHandler {
    private EditorMenuHandler() {
    }

    public static class_3908 getMenuProvider(final EditorType editorType, final EasyNPC<?> easyNPC, final class_3917<? extends EditorMenu> menuType, final ScreenData screenData) {
        final class_2561 displayName = EditorMenuHandler.getEditorTitle(editorType, easyNPC);
        return new class_3908(){

            public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
                return new EditorMenu(menuType, containerId, playerInventory, screenData.encode());
            }

            public class_2561 method_5476() {
                return displayName;
            }

            public String toString() {
                return "EditorMenuHandler{editorType=" + String.valueOf(editorType) + ", easyNPC=" + String.valueOf(easyNPC) + ", screenData=" + String.valueOf(screenData) + "}";
            }
        };
    }

    public static ScreenData getScreenData(EditorType editorType, EasyNPC<? extends class_1309> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, class_2487 additionalSyncData) {
        UUID npcUUID = easyNPC.getEntityUUID();
        switch (editorType) {
            case DIALOG: 
            case DIALOG_BUTTON: 
            case DIALOG_TEXT: {
                AdditionalScreenData.addDialogDataSet((class_2487)additionalSyncData, easyNPC);
                break;
            }
            case ACTION_DATA: 
            case ACTION_DATA_ENTRY: {
                AdditionalScreenData.addActionEventSet((class_2487)additionalSyncData, easyNPC);
                AdditionalScreenData.addDialogDataSet((class_2487)additionalSyncData, easyNPC);
                break;
            }
        }
        return new ScreenData(npcUUID, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
    }

    private static class_2561 getEditorTitle(EditorType editorType, EasyNPC<?> easyNPC) {
        return TextComponent.getTranslatedConfigText((String)(editorType.name().toLowerCase(Locale.ROOT) + ".title"), (String)easyNPC.getEntity().method_5477().method_10858(20));
    }
}

