/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.objective;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.SaveButton;
import de.markusbordihn.easynpc.client.screen.components.TextField;
import de.markusbordihn.easynpc.configui.client.screen.configuration.objective.ObjectiveConfigurationScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataEntry;
import de.markusbordihn.easynpc.data.objective.ObjectiveType;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class FollowObjectiveConfigurationScreen<T extends ConfigurationMenu>
extends ObjectiveConfigurationScreen<T> {
    protected Checkbox followOwnerCheckbox;
    protected Checkbox followPlayerCheckbox;
    protected EditBox followPlayerName;
    protected Button followPlayerNameSaveButton;
    protected Checkbox followEntityCheckbox;
    protected EditBox followEntityUUID;
    protected Button followEntityUUIDSaveButton;

    public FollowObjectiveConfigurationScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    @Override
    public void init() {
        super.init();
        this.followObjectiveButton.active = false;
        int objectiveEntriesTop = this.contentTopPos + 5;
        int objectiveEntriesFirstColumn = this.contentLeftPos + 5;
        int objectiveEntriesSecondColumn = this.contentLeftPos + 145;
        OwnerDataCapable ownerData = this.getOwnerData();
        this.followOwnerCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop, ObjectiveType.FOLLOW_OWNER.getObjectiveName(), ownerData.getNPCOwnerName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_OWNER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_OWNER, 6);
            objectiveDataEntry.setTargetOwnerUUID(ownerData.getOwnerUUID());
            if (checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followPlayerCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_PLAYER.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER, 7);
            if (this.followPlayerName != null) {
                objectiveDataEntry.setTargetPlayerName(this.followPlayerName.getValue());
                this.followPlayerName.setEditable(checkbox.selected());
            }
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.active = checkbox.selected();
            }
            if (!checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else if (!this.followPlayerName.getValue().isEmpty()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followOwnerCheckbox.active = ownerData.hasNPCOwner();
        this.followPlayerName = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, objectiveEntriesSecondColumn, objectiveEntriesTop, 125));
        this.followPlayerName.setEditable(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER));
        this.followPlayerName.setResponder(value -> {
            if (this.followPlayerNameSaveButton != null) {
                this.followPlayerNameSaveButton.active = value != null && !value.isEmpty();
            }
        });
        this.followPlayerName.setValue(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_PLAYER) ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_PLAYER).getTargetPlayerName() : "");
        this.followPlayerNameSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.followPlayerName.getX() + this.followPlayerName.getWidth() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_PLAYER);
            objectiveDataEntry.setTargetPlayerName(this.followPlayerName.getValue());
            NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
        }));
        this.followEntityCheckbox = (Checkbox)this.addRenderableWidget((GuiEventListener)new Checkbox(objectiveEntriesFirstColumn, objectiveEntriesTop += 20, ObjectiveType.FOLLOW_ENTITY_BY_UUID.getObjectiveName(), this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID), checkbox -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            if (this.followEntityUUID != null) {
                if (!this.followEntityUUID.getValue().isEmpty()) {
                    UUID entityUUID = null;
                    try {
                        entityUUID = UUID.fromString(this.followEntityUUID.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Unable to parse UUID {} for {}", (Object)this.followEntityUUID.getValue(), (Object)this.getEasyNPCUUID());
                    }
                    if (entityUUID != null) {
                        objectiveDataEntry.setTargetEntityUUID(entityUUID);
                    }
                }
                this.followEntityUUID.setEditable(checkbox.selected());
            }
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.active = checkbox.selected();
            }
            if (!checkbox.selected()) {
                NetworkMessageHandlerManager.getServerHandler().removeObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            } else if (!this.followEntityUUID.getValue().isEmpty()) {
                NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
            }
        }));
        this.followEntityUUID = (EditBox)this.addRenderableWidget((GuiEventListener)new TextField(this.font, objectiveEntriesSecondColumn, objectiveEntriesTop, 125));
        this.followEntityUUID.setMaxLength(36);
        this.followEntityUUID.setEditable(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID));
        this.followEntityUUID.setResponder(value -> {
            if (this.followEntityUUIDSaveButton != null) {
                this.followEntityUUIDSaveButton.active = value != null && !value.isEmpty();
            }
        });
        this.followEntityUUID.setValue(this.objectiveDataSet.hasObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID) && this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID() != null ? this.objectiveDataSet.getObjective(ObjectiveType.FOLLOW_ENTITY_BY_UUID).getTargetEntityUUID().toString() : "");
        this.followEntityUUIDSaveButton = (Button)this.addRenderableWidget((GuiEventListener)new SaveButton(this.followEntityUUID.getX() + this.followEntityUUID.getWidth() + 5, objectiveEntriesTop - 1, onPress -> {
            ObjectiveDataEntry objectiveDataEntry = new ObjectiveDataEntry(ObjectiveType.FOLLOW_ENTITY_BY_UUID, 7);
            objectiveDataEntry.setTargetEntityUUID(!this.followEntityUUID.getValue().isEmpty() ? UUID.fromString(this.followEntityUUID.getValue()) : null);
            NetworkMessageHandlerManager.getServerHandler().addOrUpdateObjective(this.getEasyNPCUUID(), objectiveDataEntry);
        }));
    }
}

