/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu;

import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.configui.menu.MenuManager;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenuHandler;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenu;
import de.markusbordihn.easynpc.configui.menu.editor.EditorMenuHandler;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationType;
import de.markusbordihn.easynpc.data.configuration.ConfigurationTypeHelper;
import de.markusbordihn.easynpc.data.editor.EditorType;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface MenuHandlerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");

    default public void openConfigurationMenu(ConfigurationType configurationType, class_3222 serverPlayer, EasyNPC<?> easyNPC, int pageIndex) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        ConfigurationType configurationTypeAlias = ConfigurationTypeHelper.resolveConfigurationTypeAlias((ConfigurationType)configurationType, easyNPC);
        class_3917<? extends ConfigurationMenu> menuType = this.getMenuTypeByConfigurationType(configurationTypeAlias);
        if (menuType == null) {
            log.error("Unknown configuration {} for {} from {}", (Object)configurationTypeAlias, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = ConfigurationMenuHandler.getScreenData(configurationTypeAlias, easyNPC, serverPlayer, pageIndex);
        class_3908 menuProvider = ConfigurationMenuHandler.getMenuProvider(configurationTypeAlias, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, ActionEventType actionEventType, ConfigurationType configurationType, EditorType formerEditorType, int pageIndex) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        class_2487 additionalSyncData = new class_2487();
        AdditionalScreenData.addActionEventType((class_2487)additionalSyncData, (ActionEventType)actionEventType);
        AdditionalScreenData.addConfigurationType((class_2487)additionalSyncData, (ConfigurationType)configurationType);
        AdditionalScreenData.addEditorType((class_2487)additionalSyncData, (EditorType)formerEditorType);
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, null, null, pageIndex, new class_2487());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, int pageIndex) {
        this.openEditorMenu(editorType, serverPlayer, easyNPC, dialogId, dialogButtonId, null, pageIndex, new class_2487());
    }

    default public void openEditorMenu(EditorType editorType, class_3222 serverPlayer, EasyNPC<?> easyNPC, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, class_2487 additionalSyncData) {
        if (!AccessManager.hasAccess((class_3222)serverPlayer, easyNPC)) {
            return;
        }
        class_3917<? extends EditorMenu> menuType = this.getMenuTypeByEditorType(editorType);
        if (menuType == null) {
            log.error("Unknown editor {} for {} from {}", (Object)editorType, easyNPC, (Object)serverPlayer);
            return;
        }
        ScreenData screenData = EditorMenuHandler.getScreenData(editorType, easyNPC, dialogId, dialogButtonId, actionDataEntryId, pageIndex, additionalSyncData);
        class_3908 menuProvider = EditorMenuHandler.getMenuProvider(editorType, easyNPC, menuType, screenData);
        UUID npcUUID = easyNPC.getEntityUUID();
        MenuManager.openMenu(npcUUID, menuProvider, serverPlayer, screenData.encode());
    }

    public class_3917<? extends ConfigurationMenu> getMenuTypeByConfigurationType(ConfigurationType var1);

    public class_3917<? extends EditorMenu> getMenuTypeByEditorType(EditorType var1);
}

