/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.SkinHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public record ChangeSkinMessage(UUID uuid, String skinName, String skinURL, UUID skinUUID, SkinType skinType, String skinVariantType) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_npc_config_ui", "change_skin");

    public static ChangeSkinMessage create(class_2540 buffer) {
        return new ChangeSkinMessage(buffer.method_10790(), buffer.method_19772(), buffer.method_19772(), buffer.method_10790(), (SkinType)buffer.method_10818(SkinType.class), buffer.method_19772());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10814(this.skinName);
        buffer.method_10814(this.skinURL);
        buffer.method_10797(this.skinUUID);
        buffer.method_10817((Enum)this.skinType);
        buffer.method_10814(this.skinVariantType);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public void handleServer(class_3222 serverPlayer) {
        boolean successfullyChanged;
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null || this.skinName == null || this.skinType == null || easyNPC.getEasyNPCSkinData() == null) {
            log.error("Skin validation failed for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        switch (this.skinType) {
            case NONE: {
                boolean bl = SkinHandler.setNoneSkin((EasyNPC)easyNPC);
                break;
            }
            case CUSTOM: {
                boolean bl = SkinHandler.setCustomSkin((EasyNPC)easyNPC, (UUID)this.skinUUID);
                break;
            }
            case DEFAULT: {
                boolean bl = SkinHandler.setDefaultSkin((EasyNPC)easyNPC, (String)this.skinVariantType);
                break;
            }
            case PLAYER_SKIN: {
                UUID userUUID = this.skinUUID;
                if (userUUID == null || Constants.EMPTY_UUID.equals(this.skinUUID)) {
                    log.debug("Try to convert user {} to UUID ...", (Object)this.skinName);
                    userUUID = PlayersUtils.getUserUUID((MinecraftServer)serverPlayer.method_5682(), (String)this.skinName);
                }
                boolean bl = SkinHandler.setPlayerSkin((EasyNPC)easyNPC, (String)this.skinName, (UUID)userUUID);
                break;
            }
            case SECURE_REMOTE_URL: 
            case INSECURE_REMOTE_URL: {
                boolean bl = SkinHandler.setRemoteSkin((EasyNPC)easyNPC, (String)this.skinURL);
                break;
            }
            default: {
                log.error("Failed processing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, (Object)easyNPC, (Object)serverPlayer);
                boolean bl = successfullyChanged = false;
            }
        }
        if (!successfullyChanged) {
            log.error("Failed changing skin:{} uuid:{} url:{} type:{} for {} from {}", (Object)this.skinName, (Object)this.skinUUID, (Object)this.skinURL, (Object)this.skinType, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

