/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network;

import de.markusbordihn.easynpc.configui.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.configui.network.message.client.ExportClientPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.configui.network.message.client.SyncDataMessage;
import de.markusbordihn.easynpc.configui.network.message.server.AddOrUpdateObjectiveMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeActionEventMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeAdvancedTradingMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeBasicTradingMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeCombatAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeDisplayAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeEntityAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeEntityBaseAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeEnvironmentalAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeInteractionAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelEquipmentVisibilityMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelPoseMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelPositionMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelRotationMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelScaleMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeModelVisibilityMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeMovementAttributeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeNameMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangePoseMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangePositionMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeProfessionMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeRendererMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeSkinMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ChangeTradingTypeMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ExportPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ExportWorldPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.server.ImportPresetMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenActionDataEditorMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenActionDataEntryEditorMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenConfigurationMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenDialogButtonEditorMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenDialogEditorMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenDialogTextEditorMessage;
import de.markusbordihn.easynpc.configui.network.message.server.OpenMenuMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RemoveDialogButtonMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RemoveDialogMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RemoveNPCMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RemoveObjectiveMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RequestDataSyncMessage;
import de.markusbordihn.easynpc.configui.network.message.server.RespawnNPCMessage;
import de.markusbordihn.easynpc.configui.network.message.server.SaveDialogButtonMessage;
import de.markusbordihn.easynpc.configui.network.message.server.SaveDialogMessage;
import de.markusbordihn.easynpc.configui.network.message.server.SaveDialogSetMessage;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandlerManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static NetworkHandlerInterface networkHandler;
    private static NetworkHandlerManagerType networkHandlerManagerType;

    private NetworkHandlerManager() {
    }

    public static void registerHandler(NetworkHandlerInterface networkHandler) {
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Config UI");
        NetworkHandlerManager.networkHandler = networkHandler;
    }

    public static NetworkHandlerInterface getHandler() {
        return networkHandler;
    }

    public static void registerNetworkMessages(NetworkHandlerManagerType networkHandlerType) {
        log.info("Registering network messages for {} side ...", (Object)networkHandlerType);
        networkHandlerManagerType = networkHandlerType;
        NetworkHandlerManager.registerClientNetworkHandler();
        NetworkHandlerManager.registerServerNetworkHandler();
    }

    public static boolean isClientNetworkHandler() {
        return networkHandlerManagerType == NetworkHandlerManagerType.CLIENT || networkHandlerManagerType == NetworkHandlerManagerType.BOTH;
    }

    public static boolean isServerNetworkHandler() {
        return networkHandlerManagerType == NetworkHandlerManagerType.SERVER || networkHandlerManagerType == NetworkHandlerManagerType.BOTH;
    }

    public static void sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler != null) {
            networkHandler.sendMessageToServer(networkMessageRecord);
        }
    }

    public static void sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, class_3222 serverPlayer) {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler != null) {
            networkHandler.sendMessageToPlayer(networkMessageRecord, serverPlayer);
        }
    }

    public static void registerClientNetworkHandler() {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler == null) {
            log.error("Failed to register client network handler!");
            return;
        }
        log.info("Registering client network handler ...");
        networkHandler.registerClientNetworkMessage(ExportClientPresetMessage.PAYLOAD_TYPE, ExportClientPresetMessage.STREAM_CODEC, ExportClientPresetMessage.class, ExportClientPresetMessage::create);
        networkHandler.registerClientNetworkMessage(OpenMenuCallbackMessage.PAYLOAD_TYPE, OpenMenuCallbackMessage.STREAM_CODEC, OpenMenuCallbackMessage.class, OpenMenuCallbackMessage::create);
        networkHandler.registerClientNetworkMessage(SyncDataMessage.PAYLOAD_TYPE, SyncDataMessage.STREAM_CODEC, SyncDataMessage.class, SyncDataMessage::create);
    }

    public static void registerServerNetworkHandler() {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler == null) {
            log.error("Failed to register server network handler!");
            return;
        }
        log.info("Registering server network handler ...");
        networkHandler.registerServerNetworkMessage(AddOrUpdateObjectiveMessage.PAYLOAD_TYPE, AddOrUpdateObjectiveMessage.STREAM_CODEC, AddOrUpdateObjectiveMessage.class, AddOrUpdateObjectiveMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeActionEventMessage.PAYLOAD_TYPE, ChangeActionEventMessage.STREAM_CODEC, ChangeActionEventMessage.class, ChangeActionEventMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeAdvancedTradingMessage.PAYLOAD_TYPE, ChangeAdvancedTradingMessage.STREAM_CODEC, ChangeAdvancedTradingMessage.class, ChangeAdvancedTradingMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeBasicTradingMessage.PAYLOAD_TYPE, ChangeBasicTradingMessage.STREAM_CODEC, ChangeBasicTradingMessage.class, ChangeBasicTradingMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeCombatAttributeMessage.PAYLOAD_TYPE, ChangeCombatAttributeMessage.STREAM_CODEC, ChangeCombatAttributeMessage.class, ChangeCombatAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeDisplayAttributeMessage.PAYLOAD_TYPE, ChangeDisplayAttributeMessage.STREAM_CODEC, ChangeDisplayAttributeMessage.class, ChangeDisplayAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeEntityAttributeMessage.PAYLOAD_TYPE, ChangeEntityAttributeMessage.STREAM_CODEC, ChangeEntityAttributeMessage.class, ChangeEntityAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeEntityBaseAttributeMessage.PAYLOAD_TYPE, ChangeEntityBaseAttributeMessage.STREAM_CODEC, ChangeEntityBaseAttributeMessage.class, ChangeEntityBaseAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeEnvironmentalAttributeMessage.PAYLOAD_TYPE, ChangeEnvironmentalAttributeMessage.STREAM_CODEC, ChangeEnvironmentalAttributeMessage.class, ChangeEnvironmentalAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeInteractionAttributeMessage.PAYLOAD_TYPE, ChangeInteractionAttributeMessage.STREAM_CODEC, ChangeInteractionAttributeMessage.class, ChangeInteractionAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelEquipmentVisibilityMessage.PAYLOAD_TYPE, ChangeModelEquipmentVisibilityMessage.STREAM_CODEC, ChangeModelEquipmentVisibilityMessage.class, ChangeModelEquipmentVisibilityMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelPoseMessage.PAYLOAD_TYPE, ChangeModelPoseMessage.STREAM_CODEC, ChangeModelPoseMessage.class, ChangeModelPoseMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelPositionMessage.PAYLOAD_TYPE, ChangeModelPositionMessage.STREAM_CODEC, ChangeModelPositionMessage.class, ChangeModelPositionMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelRotationMessage.PAYLOAD_TYPE, ChangeModelRotationMessage.STREAM_CODEC, ChangeModelRotationMessage.class, ChangeModelRotationMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelScaleMessage.PAYLOAD_TYPE, ChangeModelScaleMessage.STREAM_CODEC, ChangeModelScaleMessage.class, ChangeModelScaleMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeModelVisibilityMessage.PAYLOAD_TYPE, ChangeModelVisibilityMessage.STREAM_CODEC, ChangeModelVisibilityMessage.class, ChangeModelVisibilityMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeMovementAttributeMessage.PAYLOAD_TYPE, ChangeMovementAttributeMessage.STREAM_CODEC, ChangeMovementAttributeMessage.class, ChangeMovementAttributeMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeNameMessage.PAYLOAD_TYPE, ChangeNameMessage.STREAM_CODEC, ChangeNameMessage.class, ChangeNameMessage::create);
        networkHandler.registerServerNetworkMessage(ChangePoseMessage.PAYLOAD_TYPE, ChangePoseMessage.STREAM_CODEC, ChangePoseMessage.class, ChangePoseMessage::create);
        networkHandler.registerServerNetworkMessage(ChangePositionMessage.PAYLOAD_TYPE, ChangePositionMessage.STREAM_CODEC, ChangePositionMessage.class, ChangePositionMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeProfessionMessage.PAYLOAD_TYPE, ChangeProfessionMessage.STREAM_CODEC, ChangeProfessionMessage.class, ChangeProfessionMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeRendererMessage.PAYLOAD_TYPE, ChangeRendererMessage.STREAM_CODEC, ChangeRendererMessage.class, ChangeRendererMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeSkinMessage.PAYLOAD_TYPE, ChangeSkinMessage.STREAM_CODEC, ChangeSkinMessage.class, ChangeSkinMessage::create);
        networkHandler.registerServerNetworkMessage(ChangeTradingTypeMessage.PAYLOAD_TYPE, ChangeTradingTypeMessage.STREAM_CODEC, ChangeTradingTypeMessage.class, ChangeTradingTypeMessage::create);
        networkHandler.registerServerNetworkMessage(ExportPresetMessage.PAYLOAD_TYPE, ExportPresetMessage.STREAM_CODEC, ExportPresetMessage.class, ExportPresetMessage::create);
        networkHandler.registerServerNetworkMessage(ExportWorldPresetMessage.PAYLOAD_TYPE, ExportWorldPresetMessage.STREAM_CODEC, ExportWorldPresetMessage.class, ExportWorldPresetMessage::create);
        networkHandler.registerServerNetworkMessage(ImportPresetMessage.PAYLOAD_TYPE, ImportPresetMessage.STREAM_CODEC, ImportPresetMessage.class, ImportPresetMessage::create);
        networkHandler.registerServerNetworkMessage(OpenActionDataEditorMessage.PAYLOAD_TYPE, OpenActionDataEditorMessage.STREAM_CODEC, OpenActionDataEditorMessage.class, OpenActionDataEditorMessage::create);
        networkHandler.registerServerNetworkMessage(OpenActionDataEntryEditorMessage.PAYLOAD_TYPE, OpenActionDataEntryEditorMessage.STREAM_CODEC, OpenActionDataEntryEditorMessage.class, OpenActionDataEntryEditorMessage::create);
        networkHandler.registerServerNetworkMessage(OpenConfigurationMessage.PAYLOAD_TYPE, OpenConfigurationMessage.STREAM_CODEC, OpenConfigurationMessage.class, OpenConfigurationMessage::create);
        networkHandler.registerServerNetworkMessage(OpenDialogButtonEditorMessage.PAYLOAD_TYPE, OpenDialogButtonEditorMessage.STREAM_CODEC, OpenDialogButtonEditorMessage.class, OpenDialogButtonEditorMessage::create);
        networkHandler.registerServerNetworkMessage(OpenDialogEditorMessage.PAYLOAD_TYPE, OpenDialogEditorMessage.STREAM_CODEC, OpenDialogEditorMessage.class, OpenDialogEditorMessage::create);
        networkHandler.registerServerNetworkMessage(OpenMenuMessage.PAYLOAD_TYPE, OpenMenuMessage.STREAM_CODEC, OpenMenuMessage.class, OpenMenuMessage::create);
        networkHandler.registerServerNetworkMessage(OpenDialogTextEditorMessage.PAYLOAD_TYPE, OpenDialogTextEditorMessage.STREAM_CODEC, OpenDialogTextEditorMessage.class, OpenDialogTextEditorMessage::create);
        networkHandler.registerServerNetworkMessage(RemoveDialogButtonMessage.PAYLOAD_TYPE, RemoveDialogButtonMessage.STREAM_CODEC, RemoveDialogButtonMessage.class, RemoveDialogButtonMessage::create);
        networkHandler.registerServerNetworkMessage(RemoveDialogMessage.PAYLOAD_TYPE, RemoveDialogMessage.STREAM_CODEC, RemoveDialogMessage.class, RemoveDialogMessage::create);
        networkHandler.registerServerNetworkMessage(RemoveNPCMessage.PAYLOAD_TYPE, RemoveNPCMessage.STREAM_CODEC, RemoveNPCMessage.class, RemoveNPCMessage::create);
        networkHandler.registerServerNetworkMessage(RemoveObjectiveMessage.PAYLOAD_TYPE, RemoveObjectiveMessage.STREAM_CODEC, RemoveObjectiveMessage.class, RemoveObjectiveMessage::create);
        networkHandler.registerServerNetworkMessage(RequestDataSyncMessage.PAYLOAD_TYPE, RequestDataSyncMessage.STREAM_CODEC, RequestDataSyncMessage.class, RequestDataSyncMessage::create);
        networkHandler.registerServerNetworkMessage(RespawnNPCMessage.PAYLOAD_TYPE, RespawnNPCMessage.STREAM_CODEC, RespawnNPCMessage.class, RespawnNPCMessage::create);
        networkHandler.registerServerNetworkMessage(SaveDialogButtonMessage.PAYLOAD_TYPE, SaveDialogButtonMessage.STREAM_CODEC, SaveDialogButtonMessage.class, SaveDialogButtonMessage::create);
        networkHandler.registerServerNetworkMessage(SaveDialogMessage.PAYLOAD_TYPE, SaveDialogMessage.STREAM_CODEC, SaveDialogMessage.class, SaveDialogMessage::create);
        networkHandler.registerServerNetworkMessage(SaveDialogSetMessage.PAYLOAD_TYPE, SaveDialogSetMessage.STREAM_CODEC, SaveDialogSetMessage.class, SaveDialogSetMessage::create);
    }

    static {
        networkHandlerManagerType = NetworkHandlerManagerType.BOTH;
    }
}

