/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.NameHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public record ChangeNameMessage(UUID uuid, String name, int color, NameVisibilityType nameVisibilityType) implements NetworkMessageRecord
{
    public static final ResourceLocation MESSAGE_ID = ResourceLocation.fromNamespaceAndPath((String)"easy_npc_config_ui", (String)"change_name");
    public static final CustomPacketPayload.Type<ChangeNameMessage> PAYLOAD_TYPE = new CustomPacketPayload.Type(MESSAGE_ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChangeNameMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> message.write((FriendlyByteBuf)buffer), ChangeNameMessage::create);

    public static ChangeNameMessage create(FriendlyByteBuf buffer) {
        return new ChangeNameMessage(buffer.readUUID(), buffer.readUtf(), buffer.readInt(), (NameVisibilityType)buffer.readEnum(NameVisibilityType.class));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUUID(this.uuid);
        buffer.writeUtf(this.name);
        buffer.writeInt(this.color);
        buffer.writeEnum((Enum)this.nameVisibilityType);
    }

    public ResourceLocation id() {
        return MESSAGE_ID;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(ServerPlayer serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPCAndCheckAccess(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (!NameHandler.setCustomName((EasyNPC)easyNPC, (String)this.name, (int)this.color, (NameVisibilityType)this.nameVisibilityType)) {
            log.error("Unable to set custom name {} for {} from {}", (Object)this.name, (Object)easyNPC, (Object)serverPlayer);
        }
    }
}

