/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.network.message.server;

import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.dialog.DialogButtonEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.ActionHandler;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record ExecuteDialogButtonActionMessage(UUID uuid, UUID dialogId, UUID dialogButtonId) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = class_2960.method_60655((String)"easy_npc_config_ui", (String)"dialog_button_action");
    public static final class_8710.class_9154<ExecuteDialogButtonActionMessage> PAYLOAD_TYPE = new class_8710.class_9154(MESSAGE_ID);
    public static final class_9139<class_9129, ExecuteDialogButtonActionMessage> STREAM_CODEC = class_9139.method_56437((buffer, message) -> message.write((class_2540)buffer), ExecuteDialogButtonActionMessage::create);

    public static ExecuteDialogButtonActionMessage create(class_2540 buffer) {
        return new ExecuteDialogButtonActionMessage(buffer.method_10790(), buffer.method_10790(), buffer.method_10790());
    }

    public void write(class_2540 buffer) {
        buffer.method_10797(this.uuid);
        buffer.method_10797(this.dialogId);
        buffer.method_10797(this.dialogButtonId);
    }

    public class_2960 id() {
        return MESSAGE_ID;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PAYLOAD_TYPE;
    }

    public void handleServer(class_3222 serverPlayer) {
        EasyNPC easyNPC = this.getEasyNPC(this.uuid, serverPlayer);
        if (easyNPC == null) {
            return;
        }
        if (this.dialogId == null) {
            log.error("Invalid dialog id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (this.dialogButtonId == null) {
            log.error("Invalid dialog button id for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        if (dialogData == null) {
            log.error("Dialog data for {} is not available for {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        if (!dialogData.hasDialogButton(this.dialogId, this.dialogButtonId)) {
            log.error("Unknown dialog button action {} request for dialog {} for {} from {}", (Object)this.dialogButtonId, (Object)this.dialogId, (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        DialogButtonEntry dialogButtonEntry = dialogData.getDialogButton(this.dialogId, this.dialogButtonId);
        if (dialogButtonEntry == null) {
            log.error("Unable to get valid dialog button data for {} and dialog {} from {}", (Object)easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        ActionDataSet actionDataSet = dialogButtonEntry.actionDataSet();
        if (actionDataSet == null || actionDataSet.isEmpty()) {
            log.error("Empty dialog button action {} request for {} and dialog {} from {}", (Object)this.dialogButtonId, (Object)easyNPC, (Object)this.dialogId, (Object)serverPlayer);
            return;
        }
        ActionHandler actionHandler = easyNPC.getEasyNPCActionHandler();
        if (actionHandler == null) {
            log.error("Unable to get valid action handler for {} from {}", (Object)easyNPC, (Object)serverPlayer);
            return;
        }
        actionHandler.executeActions(actionDataSet, serverPlayer);
    }
}

