/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.client.screen.configuration.equipment;

import de.markusbordihn.easynpc.client.screen.components.Checkbox;
import de.markusbordihn.easynpc.client.screen.components.Graphics;
import de.markusbordihn.easynpc.client.screen.components.TextButton;
import de.markusbordihn.easynpc.configui.Constants;
import de.markusbordihn.easynpc.configui.client.renderer.screen.EntityConfigScreenRenderer;
import de.markusbordihn.easynpc.configui.client.screen.configuration.ConfigurationContainerScreen;
import de.markusbordihn.easynpc.configui.menu.configuration.ConfigurationMenu;
import de.markusbordihn.easynpc.configui.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;

public class EquipmentConfigurationContainerScreen<T extends ConfigurationMenu>
extends ConfigurationContainerScreen<T> {
    protected Button defaultEquipmentButton;

    public EquipmentConfigurationContainerScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    private void createVisibleEquipmentSlotCheckbox(int left, int top, EquipmentSlot equipmentSlot) {
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        boolean modelEquipmentVisibility = modelData.getModelPartVisibility(equipmentSlot);
        this.addRenderableWidget((GuiEventListener)new Checkbox(left, top, "", modelEquipmentVisibility, checkbox -> NetworkMessageHandlerManager.getServerHandler().modelVisibilityChange(this.getEasyNPCUUID(), equipmentSlot, checkbox.selected())));
    }

    @Override
    public void init() {
        super.init();
        int buttonWidth = 80;
        this.defaultEquipmentButton = (Button)this.addRenderableWidget((GuiEventListener)new TextButton(this.buttonLeftPos, this.buttonTopPos, buttonWidth, "equipment", button -> {}));
        this.defaultEquipmentButton.active = false;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = this.imageHeight - 92;
        int slotPositionTop = this.contentTopPos + 20;
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        if (modelData.canUseArmor()) {
            int equipmentSlotLeft = this.contentLeftPos + 75;
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, slotPositionTop + 2, EquipmentSlot.HEAD);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, slotPositionTop + 20, EquipmentSlot.CHEST);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, slotPositionTop + 38, EquipmentSlot.LEGS);
            this.createVisibleEquipmentSlotCheckbox(equipmentSlotLeft, slotPositionTop + 55, EquipmentSlot.FEET);
        }
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        super.render(guiGraphics, x, y, partialTicks);
        EntityConfigScreenRenderer.renderEntity(guiGraphics, this.getEasyNPC(), EntityRenderConfig.guiScaled((int)(this.contentLeftPos + 138), (int)(this.contentTopPos + 102), (int)35, (float)((float)(this.contentLeftPos + 138) - this.xMouse), (float)((float)(this.contentTopPos + 50) - this.yMouse)), this.xMouse, this.yMouse);
        this.renderTooltip(guiGraphics, x, y);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int slotPositionTop = this.contentTopPos + 20;
        ModelDataCapable modelData = this.getEasyNPC().getEasyNPCModelData();
        if (modelData == null || modelData.canUseArmor()) {
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 90), (int)slotPositionTop, (int)7, (int)7, (int)18, (int)72);
        }
        if (modelData == null || modelData.canUseMainHand()) {
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 90), (int)(slotPositionTop + 75), (int)7, (int)7, (int)18, (int)18);
        }
        if (modelData == null || modelData.canUseOffHand()) {
            Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 170), (int)(slotPositionTop + 75), (int)7, (int)7, (int)18, (int)18);
        }
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 58), (int)(slotPositionTop + 105), (int)7, (int)83, (int)162, (int)54);
        Graphics.blit((GuiGraphics)guiGraphics, (ResourceLocation)Constants.TEXTURE_INVENTORY, (int)(this.contentLeftPos + 58), (int)(slotPositionTop + 165), (int)7, (int)141, (int)162, (int)18);
        guiGraphics.fill(this.contentLeftPos + 109, slotPositionTop - 8, this.contentLeftPos + 169, slotPositionTop + 102, -16777216);
        guiGraphics.fill(this.contentLeftPos + 110, slotPositionTop - 7, this.contentLeftPos + 168, slotPositionTop + 101, -5592406);
    }
}

