/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.configui.menu.configuration.equipment.slot;

import de.markusbordihn.easynpc.configui.menu.configuration.equipment.EquipmentConfigurationMenu;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HandSlot
extends Slot {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Config UI");
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    public final int slotIndex;
    final EquipmentSlot equipmentSlot;
    final EquipmentConfigurationMenu menu;

    public HandSlot(EquipmentConfigurationMenu menu, Container container, int slotIndex, int x, int y) {
        super(container, slotIndex, x, y);
        this.slotIndex = slotIndex;
        this.menu = menu;
        this.equipmentSlot = SLOT_IDS[slotIndex];
    }

    public void set(ItemStack itemStack) {
        super.set(itemStack);
        this.menu.setHandChanged(this.slotIndex == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, itemStack);
    }

    public boolean mayPlace(ItemStack itemStack) {
        EasyNPC easyNPC = this.menu.getEasyNPC();
        if (itemStack.isEmpty() || easyNPC == null) {
            return false;
        }
        EquipmentSlot equipmentSlotForItem = easyNPC.getLivingEntity().getEquipmentSlotForItem(itemStack);
        return this.equipmentSlot == EquipmentSlot.OFFHAND && equipmentSlotForItem == EquipmentSlot.OFFHAND || this.equipmentSlot == EquipmentSlot.MAINHAND && equipmentSlotForItem == EquipmentSlot.MAINHAND || this.equipmentSlot == EquipmentSlot.OFFHAND && equipmentSlotForItem == EquipmentSlot.MAINHAND;
    }

    public boolean mayPickup(Player player) {
        ItemStack itemStack = this.getItem();
        return !itemStack.isEmpty() && (player.isCreative() || !EnchantmentHelper.hasTag((ItemStack)itemStack, (TagKey)EnchantmentTags.CURSE)) && super.mayPickup(player);
    }

    public ResourceLocation getNoItemIcon() {
        if (this.equipmentSlot == EquipmentSlot.OFFHAND) {
            return InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD;
        }
        return null;
    }
}

